/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.configuration;

import org.apache.ignite3.internal.pagememory.configuration.DataRegionConfiguration;

public class VolatileDataRegionConfiguration
implements DataRegionConfiguration {
    private final String name;
    private final int pageSize;
    private final long initSize;
    private final long maxSize;

    private VolatileDataRegionConfiguration(String name, int pageSize, long initSize, long maxSize) {
        this.name = name;
        this.pageSize = pageSize;
        this.initSize = initSize;
        this.maxSize = maxSize;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    public long initSizeBytes() {
        return this.initSize;
    }

    public long maxSizeBytes() {
        return this.maxSize;
    }

    public static VolatileDataRegionConfigurationBuilder builder() {
        return new VolatileDataRegionConfigurationBuilder();
    }

    public static class VolatileDataRegionConfigurationBuilder {
        private String name;
        private int pageSize;
        private long initSize;
        private long maxSize;

        public VolatileDataRegionConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VolatileDataRegionConfigurationBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public VolatileDataRegionConfigurationBuilder initSize(long initSize) {
            this.initSize = initSize;
            return this;
        }

        public VolatileDataRegionConfigurationBuilder maxSize(long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public VolatileDataRegionConfiguration build() {
            return new VolatileDataRegionConfiguration(this.name, this.pageSize, this.initSize, this.maxSize);
        }
    }
}

