/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.topology.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.TestOnly;

public class LogicalTopologySnapshot {
    public static final long FIRST_VERSION = 1L;
    public static final LogicalTopologySnapshot INITIAL = new LogicalTopologySnapshot(0L, Collections.emptySet(), new UUID(0L, 0L));
    private final long version;
    @IgniteToStringInclude
    private final Set<LogicalNode> nodes;
    private final UUID clusterId;

    public LogicalTopologySnapshot(long version, Collection<LogicalNode> nodes, UUID clusterId) {
        this.version = version;
        this.nodes = Set.copyOf(nodes);
        this.clusterId = clusterId;
    }

    @TestOnly
    public LogicalTopologySnapshot(long version, Collection<LogicalNode> nodes) {
        this(version, nodes, UUID.randomUUID());
    }

    public long version() {
        return this.version;
    }

    public Set<LogicalNode> nodes() {
        return this.nodes;
    }

    public UUID clusterId() {
        return this.clusterId;
    }

    public String toString() {
        return S.toString(LogicalTopologySnapshot.class, this);
    }
}

