/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class TransactionsHashRecord
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Object locConsistentId;
    @GridToStringInclude
    private Object rmtConsistentId;
    @GridToStringInclude
    private int txHash;

    public TransactionsHashRecord() {
    }

    public TransactionsHashRecord(Object locConsistentId, Object rmtConsistentId, int txHash) {
        this.locConsistentId = locConsistentId;
        this.rmtConsistentId = rmtConsistentId;
        this.txHash = txHash;
    }

    public int transactionHash() {
        return this.txHash;
    }

    public Object remoteConsistentId() {
        return this.rmtConsistentId;
    }

    public Object localConsistentId() {
        return this.locConsistentId;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.locConsistentId);
        out.writeObject(this.rmtConsistentId);
        out.writeInt(this.txHash);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.locConsistentId = in.readObject();
        this.rmtConsistentId = in.readObject();
        this.txHash = in.readInt();
    }

    public String toString() {
        return S.toString(TransactionsHashRecord.class, this);
    }
}

