/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.engine;

import java.util.Set;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.engine.ThreadAssertingMvTableStorage;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.apache.ignite.internal.wrapper.Wrapper;

public class ThreadAssertingStorageEngine
implements StorageEngine,
Wrapper {
    private final StorageEngine storageEngine;

    public ThreadAssertingStorageEngine(StorageEngine storageEngine) {
        this.storageEngine = storageEngine;
    }

    @Override
    public String name() {
        return this.storageEngine.name();
    }

    @Override
    public void start() throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storageEngine.start();
    }

    @Override
    public void stop() throws StorageException {
        this.storageEngine.stop();
    }

    @Override
    public boolean isVolatile() {
        return this.storageEngine.isVolatile();
    }

    @Override
    public MvTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) {
        MvTableStorage tableStorage = this.storageEngine.createMvTable(tableDescriptor, indexDescriptorSupplier);
        return new ThreadAssertingMvTableStorage(tableStorage);
    }

    @Override
    public void destroyMvTable(int tableId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storageEngine.destroyMvTable(tableId);
    }

    @Override
    public Set<Integer> tableIdsOnDisk() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storageEngine.tableIdsOnDisk();
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.storageEngine);
    }
}

