/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.storage.impl.DefaultLogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorage;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorageUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

class MetadataMigration {
    private static final IgniteLogger LOG = Loggers.forClass(MetadataMigration.class);
    private final RocksDB db;
    private final WriteOptions writeOptions;
    private final ColumnFamilyHandle metaHandle;
    private final ColumnFamilyHandle confHandle;
    private final ColumnFamilyHandle dataHandle;

    MetadataMigration(RocksDB db, WriteOptions writeOptions, ColumnFamilyHandle metaHandle, ColumnFamilyHandle confHandle, ColumnFamilyHandle dataHandle) {
        this.db = db;
        this.writeOptions = writeOptions;
        this.metaHandle = metaHandle;
        this.confHandle = confHandle;
        this.dataHandle = dataHandle;
    }

    void migrateIfNeeded() throws RocksDBException {
        if (this.metaMigrationIsFinished()) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            boolean migratingSomething = this.doMigration(writeBatch);
            this.markMetaMigrationAsFinished(writeBatch);
            this.db.write(this.writeOptions, writeBatch);
            if (migratingSomething) {
                LOG.info("Metadata migration was performed and touched some log storages.", new Object[0]);
            }
        }
    }

    private boolean metaMigrationIsFinished() throws RocksDBException {
        return this.db.get(this.metaHandle, DefaultLogStorageFactory.FINISHED_META_MIGRATION_META_KEY) != null;
    }

    private boolean doMigration(WriteBatch writeBatch) throws RocksDBException {
        boolean migratingSomething = false;
        for (String groupIdForStorage : this.raftNodeStorageIdsOnDisk()) {
            RocksDbSharedLogStorage.saveStorageStartedFlag(this.metaHandle, groupIdForStorage, writeBatch);
            migratingSomething = true;
        }
        return migratingSomething;
    }

    Set<String> raftNodeStorageIdsOnDisk() throws RocksDBException {
        HashSet<String> groupIdsForStorage = new HashSet<String>();
        try (RocksIterator confIt = this.db.newIterator(this.confHandle);
             RocksIterator dataIt = this.db.newIterator(this.dataHandle);){
            confIt.seekToFirst();
            dataIt.seekToFirst();
            while (confIt.isValid() || dataIt.isValid()) {
                RocksIterator it;
                if (confIt.isValid() && dataIt.isValid()) {
                    byte[] dataKey;
                    byte[] confKey = confIt.key();
                    int confToDataComparison = Arrays.compare(confKey, dataKey = dataIt.key());
                    if (confToDataComparison <= 0) {
                        String idForStorage = MetadataMigration.handleGroupIdIteratorEntry(confIt, confKey, groupIdsForStorage);
                        if (confToDataComparison != 0) continue;
                        MetadataMigration.skipToNextGroupKey(dataIt, idForStorage);
                        continue;
                    }
                    MetadataMigration.handleGroupIdIteratorEntry(dataIt, dataKey, groupIdsForStorage);
                    continue;
                }
                RocksIterator rocksIterator = it = confIt.isValid() ? confIt : dataIt;
                assert (it.isValid());
                MetadataMigration.handleGroupIdIteratorEntry(it, it.key(), groupIdsForStorage);
            }
            confIt.status();
            dataIt.status();
        }
        return Set.copyOf(groupIdsForStorage);
    }

    private static String handleGroupIdIteratorEntry(RocksIterator it, byte[] currentKey, Set<String> groupIdsForStorage) {
        int indexOfZero = MetadataMigration.indexOf((byte)0, currentKey);
        assert (indexOfZero >= 0) : new String(currentKey, StandardCharsets.UTF_8) + " does not have a zero byte";
        String idForStorage = new String(currentKey, 0, indexOfZero, StandardCharsets.UTF_8);
        groupIdsForStorage.add(idForStorage);
        MetadataMigration.skipToNextGroupKey(it, idForStorage);
        return idForStorage;
    }

    private static int indexOf(byte needle, byte[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    private static void skipToNextGroupKey(RocksIterator it, String idForStorage) {
        it.seek(RocksDbSharedLogStorageUtils.raftNodeStorageEndPrefix(idForStorage));
    }

    private void markMetaMigrationAsFinished(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.put(this.metaHandle, DefaultLogStorageFactory.FINISHED_META_MIGRATION_META_KEY, ArrayUtils.BYTE_EMPTY_ARRAY);
    }
}

