/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.jetbrains.annotations.Nullable;

public abstract class StorageScanNode<RowT>
extends AbstractNode<RowT> {
    private Queue<RowT> inBuff;
    @Nullable
    private final Predicate<RowT> filters;
    @Nullable
    private final Function<RowT, RowT> rowTransformer;
    private int requested;
    private int waiting;
    private boolean inLoop;
    @Nullable
    private Flow.Subscription activeSubscription;
    private boolean dataRequested;

    public StorageScanNode(ExecutionContext<RowT> ctx, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer) {
        super(ctx);
        this.inBuff = new LinkedBlockingQueue<RowT>(this.inBufSize);
        assert (ctx.txAttributes() != null) : "Transaction not initialized.";
        this.filters = filters;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.execute(this::push);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.dataRequested = false;
        this.inBuff = new LinkedBlockingQueue<RowT>(this.inBufSize);
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    protected abstract Flow.Publisher<RowT> scan();

    private void push() throws Exception {
        if (this.requested > 0 && !this.inBuff.isEmpty()) {
            int processed = 0;
            this.inLoop = true;
            try {
                while (this.requested > 0 && !this.inBuff.isEmpty()) {
                    if (processed++ >= this.inBufSize) {
                        this.execute(this::push);
                        return;
                    }
                    RowT row = this.inBuff.poll();
                    if (this.filters != null && !this.filters.test(row)) continue;
                    if (this.rowTransformer != null) {
                        row = this.rowTransformer.apply(row);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.requested > 0 && (this.waiting == 0 || this.activeSubscription == null)) {
            this.requestNextBatch();
        }
        if (this.requested > 0 && this.waiting == -1) {
            if (this.inBuff.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            } else {
                this.execute(this::push);
            }
        }
    }

    private void requestNextBatch() {
        Flow.Subscription subscription;
        if (this.waiting == -1) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        if (this.waiting == 0) {
            this.waiting = this.inBufSize - this.inBuff.size();
        }
        if ((subscription = this.activeSubscription) != null) {
            subscription.request(this.waiting);
        } else if (!this.dataRequested) {
            this.scan().subscribe(new SubscriberImpl());
            this.dataRequested = true;
        } else {
            this.waiting = -1;
        }
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting);
    }

    private class SubscriberImpl
    implements Flow.Subscriber<RowT> {
        private Queue<RowT> inBuffInner;

        private SubscriberImpl() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            assert (StorageScanNode.this.activeSubscription == null);
            this.inBuffInner = StorageScanNode.this.inBuff;
            StorageScanNode.this.activeSubscription = subscription;
            subscription.request(StorageScanNode.this.waiting);
        }

        @Override
        public void onNext(RowT row) {
            this.inBuffInner.add(row);
            if (this.inBuffInner.size() == StorageScanNode.this.inBufSize) {
                StorageScanNode.this.execute(() -> {
                    StorageScanNode.this.waiting = 0;
                    StorageScanNode.this.push();
                });
            }
        }

        @Override
        public void onError(Throwable throwable) {
            StorageScanNode.this.execute(() -> {
                throw throwable;
            });
        }

        @Override
        public void onComplete() {
            StorageScanNode.this.execute(() -> {
                StorageScanNode.this.activeSubscription = null;
                StorageScanNode.this.waiting = 0;
                StorageScanNode.this.push();
            });
        }
    }
}

