/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.schema;

import java.util.Objects;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;

public class ColumnDefinitionDiff {
    private final CatalogTableColumnDescriptor oldColumn;
    private final CatalogTableColumnDescriptor newColumn;

    public ColumnDefinitionDiff(CatalogTableColumnDescriptor oldColumn, CatalogTableColumnDescriptor newColumn) {
        this.oldColumn = oldColumn;
        this.newColumn = newColumn;
    }

    public boolean nullabilityChanged() {
        return this.oldColumn.nullable() != this.newColumn.nullable();
    }

    public boolean notNullDropped() {
        return !this.oldColumn.nullable() && this.newColumn.nullable();
    }

    public boolean notNullAdded() {
        return this.oldColumn.nullable() && !this.newColumn.nullable();
    }

    public boolean typeChanged() {
        return this.oldColumn.type() != this.newColumn.type() || this.oldColumn.precision() != this.newColumn.precision() || this.oldColumn.scale() != this.newColumn.scale() || this.oldColumn.length() != this.newColumn.length();
    }

    public boolean typeChangeIsSupported() {
        return CatalogUtils.isColumnTypeChangeSupported((CatalogTableColumnDescriptor)this.oldColumn, (CatalogTableColumnDescriptor)this.newColumn);
    }

    public boolean defaultChanged() {
        return !Objects.equals(this.oldColumn.defaultValue(), this.newColumn.defaultValue());
    }

    public String oldName() {
        return this.oldColumn.name();
    }
}

