/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.context.AbstractBeanConfiguration;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;

@Internal
public class BeanConfigurationWriter
extends AbstractAnnotationMetadataWriter {
    public static final String CLASS_SUFFIX = "$BeanConfiguration";
    private final String packageName;
    private final String configurationClassName;
    private final String configurationClassInternalName;

    public BeanConfigurationWriter(String packageName, Element originatingElement, AnnotationMetadata annotationMetadata) {
        super(packageName + '.' + CLASS_SUFFIX, originatingElement, annotationMetadata, true);
        this.packageName = packageName;
        this.configurationClassName = this.targetClassType.getClassName();
        this.configurationClassInternalName = this.targetClassType.getInternalName();
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream outputStream = classWriterOutputVisitor.visitClass(this.configurationClassName, this.getOriginatingElements());){
            ClassWriter classWriter = this.generateClassBytes();
            outputStream.write(classWriter.toByteArray());
        }
        classWriterOutputVisitor.visitServiceDescriptor(BeanConfiguration.class, this.configurationClassName, this.getOriginatingElement());
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(1);
        try {
            Class<AbstractBeanConfiguration> superType = AbstractBeanConfiguration.class;
            Type beanConfigurationType = Type.getType(superType);
            this.startService((ClassVisitor)classWriter, BeanConfiguration.class, this.configurationClassInternalName, beanConfigurationType);
            this.writeAnnotationMetadataStaticInitializer(classWriter);
            this.writeConstructor(classWriter);
            this.writeGetAnnotationMetadataMethod(classWriter);
        }
        catch (NoSuchMethodException e) {
            throw new ClassGenerationException("Error generating configuration class. Incompatible JVM or Micronaut version?: " + e.getMessage(), e);
        }
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
        return classWriter;
    }

    private void writeConstructor(ClassWriter classWriter) throws NoSuchMethodException {
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter);
        cv.loadThis();
        cv.push(this.packageName);
        this.invokeConstructor((MethodVisitor)cv, AbstractBeanConfiguration.class, String.class);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
    }
}

