/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public final class ExecutorServiceHelper {
    private static final IgniteLogger LOG = Loggers.forClass(ExecutorServiceHelper.class);

    public static boolean shutdownAndAwaitTermination(ExecutorService pool) {
        return ExecutorServiceHelper.shutdownAndAwaitTermination(pool, 1000L);
    }

    public static boolean shutdownAndAwaitTermination(ExecutorService pool, long timeoutMillis) {
        if (pool == null) {
            return true;
        }
        pool.shutdown();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        long phaseOne = timeoutMillis / 5L;
        try {
            if (pool.awaitTermination(phaseOne, unit)) {
                return true;
            }
            pool.shutdownNow();
            if (pool.awaitTermination(timeoutMillis - phaseOne, unit)) {
                return true;
            }
            LOG.warn("Fail to shutdown pool: {}.", new Object[]{pool});
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        return false;
    }
}

