/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.metrics.exporters.log;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite.shaded.com.google.auto.service.AutoService;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.exporters.PushMetricExporter;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.exporters.configuration.LogPushExporterView;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.IgniteUtils;

@AutoService(value={MetricExporter.class})
public class LogPushExporter
extends PushMetricExporter {
    public static final String EXPORTER_NAME = "logPush";
    private static final String PADDING = "  ";
    private volatile boolean oneLinePerMetricSource;
    private volatile List<String> enabledMetrics;

    @Override
    protected long period(ExporterView exporterView) {
        return ((LogPushExporterView)exporterView).periodMillis();
    }

    @Override
    public void reconfigure(ExporterView view) {
        super.reconfigure(view);
        LogPushExporterView v = (LogPushExporterView)view;
        this.oneLinePerMetricSource = v.oneLinePerMetricSource();
        this.enabledMetrics = Arrays.asList(v.enabledMetrics());
    }

    @Override
    public void report() {
        Collection<MetricSet> metricSets = this.snapshot().metrics().values();
        if (CollectionUtils.nullOrEmpty(metricSets) || CollectionUtils.nullOrEmpty(this.enabledMetrics)) {
            return;
        }
        StringBuilder report = new StringBuilder("Metric report:");
        for (MetricSet metricSet : metricSets) {
            boolean hasMetricsWhiteList = this.hasMetricsWhiteList(metricSet);
            if (!hasMetricsWhiteList && !this.metricEnabled(metricSet.name())) continue;
            report.append('\n').append(metricSet.name()).append(this.oneLinePerMetricSource ? (char)' ' : ':');
            this.appendMetrics(report, metricSet, hasMetricsWhiteList);
        }
        this.log.info(report.toString(), new Object[0]);
    }

    private void appendMetrics(StringBuilder sb, MetricSet metricSet, boolean hasMetricsWhiteList) {
        List metrics = StreamSupport.stream(metricSet.spliterator(), false).sorted(Comparator.comparing(Metric::name)).filter(m -> !hasMetricsWhiteList || this.metricEnabled(LogPushExporter.fqn(metricSet, m))).collect(Collectors.toList());
        sb.append(this.metricSetPrefix());
        IgniteUtils.forEachIndexed(metrics, (m, i) -> LogPushExporter.appendMetricWithValue(this.oneLinePerMetricSource, sb, m, i));
        sb.append(this.metricSetPostfix());
    }

    private static String commaInEnum(int i) {
        return i == 0 ? "" : ", ";
    }

    private String metricSetPrefix() {
        return this.oneLinePerMetricSource ? "[" : "";
    }

    private String metricSetPostfix() {
        return this.oneLinePerMetricSource ? "]" : "";
    }

    private static void appendMetricWithValue(boolean oneLinePerMetricSource, StringBuilder sb, Metric m, int index) {
        if (oneLinePerMetricSource) {
            sb.append(LogPushExporter.commaInEnum(index)).append(m.name()).append('=').append(m.getValueAsString());
        } else {
            sb.append('\n').append(PADDING).append(m.name()).append(": ").append(m.getValueAsString());
        }
    }

    private boolean metricEnabled(String name) {
        return IgniteUtils.findAny(this.enabledMetrics, em -> LogPushExporter.nameMatches(name, em)).isPresent();
    }

    private static String fqn(MetricSet ms, Metric m) {
        return ms.name() + "." + m.name();
    }

    private boolean hasMetricsWhiteList(MetricSet ms) {
        return IgniteUtils.findAny(this.enabledMetrics, em -> (LogPushExporter.nameMatches(ms.name(), em) || em.startsWith(ms.name())) && em.length() != ms.name().length()).isPresent();
    }

    private static boolean nameMatches(String name, String template) {
        return template.endsWith("*") && name.startsWith(template.substring(0, template.length() - 1)) || template.equals(name);
    }

    @Override
    public String name() {
        return EXPORTER_NAME;
    }
}

