/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.helix.api.config.HelixConfigProperty;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceConfig;

public class Resource {
    private final String _resourceName;
    private ClusterConfig _clusterConfig;
    private ResourceConfig _resourceConfig;
    private final Map<String, Partition> _partitionMap;
    private String _stateModelDefRef;
    private String _stateModelFactoryName;
    private int _bucketSize = 0;
    private boolean _batchMessageMode = false;
    private String _resourceGroupName;
    private String _resourceTag;

    public Resource(String resourceName) {
        this._resourceName = resourceName;
        this._partitionMap = new LinkedHashMap<String, Partition>();
    }

    public Resource(String resourceName, ClusterConfig clusterConfig, ResourceConfig resourceConfig) {
        this(resourceName);
        this._clusterConfig = clusterConfig;
        this._resourceConfig = resourceConfig;
    }

    public String getStateModelDefRef() {
        return this._stateModelDefRef;
    }

    public void setStateModelDefRef(String stateModelDefRef) {
        this._stateModelDefRef = stateModelDefRef;
    }

    public void setStateModelFactoryName(String factoryName) {
        this._stateModelFactoryName = factoryName == null ? "DEFAULT" : factoryName;
    }

    public String getStateModelFactoryname() {
        return this._stateModelFactoryName;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public Collection<Partition> getPartitions() {
        return this._partitionMap.values();
    }

    public void addPartition(String partitionName) {
        this._partitionMap.put(partitionName, new Partition(partitionName));
    }

    public Partition getPartition(String partitionName) {
        return this._partitionMap.get(partitionName);
    }

    public int getBucketSize() {
        return this._bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        this._bucketSize = bucketSize;
    }

    public void setBatchMessageMode(boolean mode) {
        this._batchMessageMode = mode;
    }

    public boolean getBatchMessageMode() {
        return this._batchMessageMode;
    }

    public String getResourceTag() {
        return this._resourceTag;
    }

    public void setResourceTag(String resourceTag) {
        this._resourceTag = resourceTag;
    }

    public String getResourceGroupName() {
        return this._resourceGroupName;
    }

    public void setResourceGroupName(String resourceGroupName) {
        this._resourceGroupName = resourceGroupName;
    }

    public boolean isP2PMessageEnabled() {
        String enabledInResource;
        String string = enabledInResource = this._resourceConfig != null ? this._resourceConfig.getRecord().getSimpleField(HelixConfigProperty.P2P_MESSAGE_ENABLED.name()) : null;
        if (enabledInResource != null) {
            return Boolean.valueOf(enabledInResource);
        }
        String enabledInCluster = this._clusterConfig != null ? this._clusterConfig.getRecord().getSimpleField(HelixConfigProperty.P2P_MESSAGE_ENABLED.name()) : null;
        return enabledInCluster != null ? Boolean.valueOf(enabledInCluster) : false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("resourceName:").append(this._resourceName);
        sb.append(", stateModelDef:").append(this._stateModelDefRef);
        sb.append(", bucketSize:").append(this._bucketSize);
        sb.append(", partitionStateMap:").append(this._partitionMap);
        return sb.toString();
    }
}

