/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.api.listeners.ControllerChangeListener;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.manager.zk.ControllerManagerHelper;
import org.apache.helix.model.ControllerHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLeaderElection
implements ControllerChangeListener {
    private static Logger LOG = LoggerFactory.getLogger(DistributedLeaderElection.class);
    private final HelixManager _manager;
    private final GenericHelixController _controller;
    private final List<HelixTimerTask> _controllerTimerTasks;

    public DistributedLeaderElection(HelixManager manager, GenericHelixController controller, List<HelixTimerTask> controllerTimerTasks) {
        this._manager = manager;
        this._controller = controller;
        this._controllerTimerTasks = controllerTimerTasks;
        InstanceType type = this._manager.getInstanceType();
        if (type != InstanceType.CONTROLLER && type != InstanceType.CONTROLLER_PARTICIPANT) {
            throw new HelixException("fail to become controller because incorrect instanceType (was " + type.toString() + ", requires CONTROLLER | CONTROLLER_PARTICIPANT)");
        }
    }

    @Override
    public synchronized void onControllerChange(NotificationContext changeContext) {
        ControllerManagerHelper controllerHelper = new ControllerManagerHelper(this._manager, this._controllerTimerTasks);
        try {
            switch (changeContext.getType()) {
                case INIT: 
                case CALLBACK: {
                    this.acquireLeadership(this._manager, controllerHelper);
                    break;
                }
                case FINALIZE: {
                    this.relinquishLeadership(this._manager, controllerHelper);
                    break;
                }
                default: {
                    LOG.info("Ignore controller change event {}. Type {}.", (Object)changeContext.getEventName(), (Object)changeContext.getType().name());
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception when trying to become leader", (Throwable)e);
        }
    }

    private void relinquishLeadership(HelixManager manager, ControllerManagerHelper controllerHelper) {
        long start = System.currentTimeMillis();
        LOG.info(manager.getInstanceName() + " tries to relinquish leadership for cluster: " + manager.getClusterName());
        controllerHelper.stopControllerTimerTasks();
        controllerHelper.removeListenersFromController(this._controller);
        manager.getHelixDataAccessor().getBaseDataAccessor().reset();
        LOG.info("{} relinquishes leadership for cluster: {}, took: {}ms", new Object[]{manager.getInstanceName(), manager.getClusterName(), System.currentTimeMillis() - start});
    }

    private void acquireLeadership(HelixManager manager, ControllerManagerHelper controllerHelper) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey leaderNodePropertyKey = accessor.keyBuilder().controllerLeader();
        LOG.info(manager.getInstanceName() + " tries to acquire leadership for cluster: " + manager.getClusterName());
        do {
            long start = System.currentTimeMillis();
            if (!this.tryCreateController(manager)) continue;
            manager.getHelixDataAccessor().getBaseDataAccessor().reset();
            controllerHelper.addListenersToController(this._controller);
            controllerHelper.startControllerTimerTasks();
            LOG.info("{} with session {} acquired leadership for cluster: {}, took: {}ms", new Object[]{manager.getInstanceName(), manager.getSessionId(), manager.getClusterName(), System.currentTimeMillis() - start});
        } while (accessor.getProperty(leaderNodePropertyKey) == null);
    }

    private boolean tryCreateController(HelixManager manager) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance newLeader = new LiveInstance(manager.getInstanceName());
        newLeader.setLiveInstance(ManagementFactory.getRuntimeMXBean().getName());
        newLeader.setSessionId(manager.getSessionId());
        newLeader.setHelixVersion(manager.getVersion());
        try {
            if (accessor.createControllerLeader(newLeader)) {
                this.updateHistory(manager);
                return true;
            }
            LOG.info("Unable to become leader probably because some other controller became the leader.");
        }
        catch (Exception e) {
            LOG.error("Exception when trying to updating leader record in cluster:" + manager.getClusterName() + ". Need to check again whether leader node has been created or not.", (Throwable)e);
        }
        LiveInstance currentLeader = (LiveInstance)accessor.getProperty(keyBuilder.controllerLeader());
        if (currentLeader != null) {
            String currentSession = currentLeader.getEphemeralOwner();
            LOG.info("Leader exists for cluster: " + manager.getClusterName() + ", currentLeader: " + currentLeader.getInstanceName() + ", leaderSessionId: " + currentSession);
            if (currentSession != null && currentSession.equals(newLeader.getEphemeralOwner())) {
                return true;
            }
            LOG.warn("The existing leader has a different session. Expected session Id: " + newLeader.getEphemeralOwner());
        }
        return false;
    }

    private void updateHistory(HelixManager manager) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String clusterName = manager.getClusterName();
        String instanceName = manager.getInstanceName();
        String version = manager.getVersion();
        if (!accessor.getBaseDataAccessor().update(keyBuilder.controllerLeaderHistory().getPath(), oldRecord -> {
            if (oldRecord == null) {
                oldRecord = new ZNRecord(PropertyType.HISTORY.toString());
            }
            return new ControllerHistory((ZNRecord)oldRecord).updateHistory(clusterName, instanceName, version);
        }, AccessOption.PERSISTENT)) {
            LOG.error("Failed to persist leader history to ZK!");
        }
    }
}

