/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.rest.client.CustomRestClientFactory;
import org.apache.helix.rest.clusterMaintenanceService.HealthCheck;
import org.apache.helix.rest.clusterMaintenanceService.MaintenanceManagementService;
import org.apache.helix.rest.clusterMaintenanceService.StoppableInstancesSelector;
import org.apache.helix.rest.server.filters.ClusterAuth;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.json.instance.StoppableCheck;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.exceptions.HelixHealthException;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.rest.server.service.ClusterServiceImpl;
import org.apache.helix.util.InstanceValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClusterAuth
@Path(value="/clusters/{clusterId}/instances")
public class InstancesAccessor
extends AbstractHelixResource {
    private static final Logger _logger = LoggerFactory.getLogger(InstancesAccessor.class);

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    public Response getAllInstances(@PathParam(value="clusterId") String clusterId, @DefaultValue(value="getAllInstances") @QueryParam(value="command") String command) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        List instances = accessor.getChildNames(accessor.keyBuilder().instanceConfigs());
        if (instances == null) {
            return this.notFound();
        }
        switch (cmd) {
            case getAllInstances: {
                ObjectNode root = JsonNodeFactory.instance.objectNode();
                root.put(AbstractResource.Properties.id.name(), (JsonNode)JsonNodeFactory.instance.textNode(clusterId));
                ArrayNode instancesNode = root.putArray(InstancesProperties.instances.name());
                instancesNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)instances));
                ArrayNode onlineNode = root.putArray(InstancesProperties.online.name());
                ArrayNode disabledNode = root.putArray(InstancesProperties.disabled.name());
                List liveInstances = accessor.getChildNames(accessor.keyBuilder().liveInstances());
                ClusterConfig clusterConfig = (ClusterConfig)accessor.getProperty(accessor.keyBuilder().clusterConfig());
                for (String instanceName : instances) {
                    InstanceConfig instanceConfig = (InstanceConfig)accessor.getProperty(accessor.keyBuilder().instanceConfig(instanceName));
                    if (instanceConfig == null) continue;
                    if (!InstanceValidationUtil.isInstanceEnabled((InstanceConfig)instanceConfig, (ClusterConfig)clusterConfig)) {
                        disabledNode.add((JsonNode)JsonNodeFactory.instance.textNode(instanceName));
                    }
                    if (!liveInstances.contains(instanceName)) continue;
                    onlineNode.add((JsonNode)JsonNodeFactory.instance.textNode(instanceName));
                }
                return this.JSONRepresentation(root);
            }
            case validateWeight: {
                Map validationResultMap;
                HelixAdmin admin = this.getHelixAdmin();
                try {
                    validationResultMap = admin.validateInstancesForWagedRebalance(clusterId, instances);
                }
                catch (HelixException e) {
                    return this.badRequest(e.getMessage());
                }
                return this.JSONRepresentation(validationResultMap);
            }
        }
        _logger.error("Unsupported command :" + command);
        return this.badRequest("Unsupported command :" + command);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    public Response instancesOperations(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String command, @QueryParam(value="continueOnFailures") boolean continueOnFailures, @QueryParam(value="skipZKRead") boolean skipZKRead, @QueryParam(value="skipHealthCheckCategories") String skipHealthCheckCategories, @DefaultValue(value="false") @QueryParam(value="random") boolean random, String content) {
        Set<StoppableCheck.Category> skipHealthCheckCategorySet;
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        try {
            Set<StoppableCheck.Category> set = skipHealthCheckCategorySet = skipHealthCheckCategories != null ? StoppableCheck.Category.categorySetFromCommaSeperatedString(skipHealthCheckCategories) : Collections.emptySet();
            if (!MaintenanceManagementService.SKIPPABLE_HEALTH_CHECK_CATEGORIES.containsAll(skipHealthCheckCategorySet)) {
                throw new IllegalArgumentException("Some of the provided skipHealthCheckCategories are not skippable. The supported skippable categories are: " + MaintenanceManagementService.SKIPPABLE_HEALTH_CHECK_CATEGORIES);
            }
        }
        catch (Exception e) {
            return this.badRequest("Invalid skipHealthCheckCategories: " + skipHealthCheckCategories + "\n" + e.getMessage());
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            JsonNode node = null;
            if (content.length() != 0) {
                node = OBJECT_MAPPER.readTree(content);
            }
            if (node == null) {
                return this.badRequest("Invalid input for content : " + content);
            }
            List enableInstances = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.instances.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            switch (cmd) {
                case enable: {
                    admin.enableInstance(clusterId, enableInstances, true);
                    break;
                }
                case disable: {
                    admin.enableInstance(clusterId, enableInstances, false);
                    break;
                }
                case stoppable: {
                    return this.batchGetStoppableInstances(clusterId, node, skipZKRead, continueOnFailures, skipHealthCheckCategorySet, random);
                }
                default: {
                    _logger.error("Unsupported command :" + command);
                    return this.badRequest("Unsupported command :" + command);
                }
            }
        }
        catch (HelixHealthException e) {
            _logger.error(String.format("Current cluster %s has issue with health checks!", clusterId), (Throwable)e);
            return this.serverError(e);
        }
        catch (Exception e) {
            _logger.error("Failed in updating instances : " + content, (Throwable)e);
            return this.badRequest(e.getMessage());
        }
        return this.OK();
    }

    private Response batchGetStoppableInstances(String clusterId, JsonNode node, boolean skipZKRead, boolean continueOnFailures, Set<StoppableCheck.Category> skipHealthCheckCategories, boolean random) throws IOException {
        try {
            ObjectNode result;
            InstanceHealthSelectionBase selectionBase = InstanceHealthSelectionBase.valueOf(node.get(InstancesProperties.selection_base.name()).textValue());
            List instances = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.instances.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            List orderOfZone = null;
            String customizedInput = null;
            List toBeStoppedInstances = Collections.emptyList();
            List<HealthCheck> skipStoppableCheckList = Collections.emptyList();
            if (node.get(InstancesProperties.customized_values.name()) != null) {
                customizedInput = node.get(InstancesProperties.customized_values.name()).toString();
            }
            if (node.get(InstancesProperties.zone_order.name()) != null && !(orderOfZone = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.zone_order.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class))).isEmpty() && random) {
                String message = "Both 'zone_order' and 'random' parameters are set. Please specify only one option.";
                _logger.error(message);
                return this.badRequest(message);
            }
            if (node.get(InstancesProperties.to_be_stopped_instances.name()) != null) {
                toBeStoppedInstances = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.to_be_stopped_instances.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
                HashSet instanceSet = new HashSet(instances);
                instanceSet.retainAll(toBeStoppedInstances);
                if (!instanceSet.isEmpty()) {
                    String message = "'to_be_stopped_instances' and 'instances' have intersection: " + instanceSet + ". Please make them mutually exclusive.";
                    _logger.error(message);
                    return this.badRequest(message);
                }
            }
            if (node.get(InstancesProperties.skip_stoppable_check_list.name()) != null) {
                List list = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.skip_stoppable_check_list.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
                try {
                    skipStoppableCheckList = list.stream().map(HealthCheck::valueOf).collect(Collectors.toList());
                }
                catch (IllegalArgumentException e) {
                    String message = "'skip_stoppable_check_list' has invalid check names: " + list + ". Supported checks: " + HealthCheck.STOPPABLE_CHECK_LIST;
                    _logger.error(message, (Throwable)e);
                    return this.badRequest(message);
                }
            }
            String namespace = this.getNamespace();
            MaintenanceManagementService maintenanceService = new MaintenanceManagementService.MaintenanceManagementServiceBuilder().setDataAccessor((ZKHelixDataAccessor)this.getDataAccssor(clusterId)).setConfigAccessor(this.getConfigAccessor()).setSkipZKRead(skipZKRead).setNonBlockingHealthChecks(continueOnFailures ? Collections.singleton("allHealthCheckNonBlock") : null).setCustomRestClient(CustomRestClientFactory.get()).setSkipHealthCheckCategories(skipHealthCheckCategories).setNamespace(namespace).setSkipStoppableHealthCheckList(skipStoppableCheckList).build();
            ClusterServiceImpl clusterService = new ClusterServiceImpl(this.getDataAccssor(clusterId), this.getConfigAccessor());
            ClusterTopology clusterTopology = clusterService.getClusterTopology(clusterId);
            StoppableInstancesSelector stoppableInstancesSelector = new StoppableInstancesSelector.StoppableInstancesSelectorBuilder().setClusterId(clusterId).setOrderOfZone(orderOfZone).setCustomizedInput(customizedInput).setMaintenanceService(maintenanceService).setClusterTopology(clusterTopology).setDataAccessor((ZKHelixDataAccessor)this.getDataAccssor(clusterId)).build();
            stoppableInstancesSelector.calculateOrderOfZone(instances, random);
            switch (selectionBase) {
                case zone_based: {
                    result = stoppableInstancesSelector.getStoppableInstancesInSingleZone(instances, toBeStoppedInstances);
                    break;
                }
                case cross_zone_based: {
                    result = stoppableInstancesSelector.getStoppableInstancesCrossZones(instances, toBeStoppedInstances);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("instance_based selection is not supported yet!");
                }
            }
            return this.JSONRepresentation(result);
        }
        catch (HelixException e) {
            _logger.error(String.format("Current cluster %s has issue with health checks!", clusterId), (Throwable)e);
            throw new HelixHealthException(e);
        }
        catch (Exception e) {
            _logger.error(String.format("Failed to get parallel stoppable instances for cluster %s with a HelixException!", clusterId), (Throwable)e);
            throw e;
        }
    }

    public static enum InstanceHealthSelectionBase {
        instance_based,
        zone_based,
        cross_zone_based;

    }

    public static enum InstancesProperties {
        instances,
        online,
        disabled,
        selection_base,
        zone_order,
        to_be_stopped_instances,
        skip_stoppable_check_list,
        customized_values,
        instance_stoppable_parallel,
        instance_not_stoppable_with_reasons;

    }
}

