/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.customizedstate;

import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.customizedstate.CustomizedStateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedStateProviderFactory {
    private static Logger LOG = LoggerFactory.getLogger(CustomizedStateProvider.class);

    protected CustomizedStateProviderFactory() {
    }

    public static CustomizedStateProviderFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public CustomizedStateProvider buildCustomizedStateProvider(String instanceName, String clusterName, String zkAddress) {
        HelixManager helixManager = HelixManagerFactory.getZKHelixManager(clusterName, instanceName, InstanceType.ADMINISTRATOR, zkAddress);
        return new CustomizedStateProvider(helixManager, instanceName);
    }

    public CustomizedStateProvider buildCustomizedStateProvider(HelixManager helixManager, String instanceName) {
        return new CustomizedStateProvider(helixManager, instanceName);
    }

    private static class SingletonHelper {
        private static final CustomizedStateProviderFactory INSTANCE = new CustomizedStateProviderFactory();

        private SingletonHelper() {
        }
    }
}

