/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.UsageSoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class InstancePartitionsCountConstraint
extends UsageSoftConstraint {
    InstancePartitionsCountConstraint() {
    }

    @Override
    protected double getAssignmentScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        int estimatedMaxPartitionCount = clusterContext.getEstimatedMaxPartitionCount();
        int currentPartitionCount = node.getAssignedReplicaCount();
        return this.computeUtilizationScore(estimatedMaxPartitionCount, currentPartitionCount);
    }
}

