/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.List;
import org.apache.helix.util.StringTemplate;

public class HelixConfigScope {
    private static final StringTemplate template = new StringTemplate();
    final ConfigScopeProperty _type;
    final String _clusterName;
    final String _participantName;
    final String _zkPath;
    final String _mapKey;
    final boolean _isFullKey;

    public HelixConfigScope(ConfigScopeProperty type, List<String> zkPathKeys, String mapKey) {
        if (zkPathKeys.size() != type.getZkPathArgNum() && zkPathKeys.size() != type.getZkPathArgNum() - 1) {
            throw new IllegalArgumentException(type + " requires " + type.getZkPathArgNum() + " arguments to get znode or " + (type.getZkPathArgNum() - 1) + " arguments to get children, but was: " + zkPathKeys);
        }
        this._isFullKey = type == ConfigScopeProperty.PARTITION ? zkPathKeys.size() == type.getZkPathArgNum() && mapKey != null : zkPathKeys.size() == type.getZkPathArgNum();
        this._type = type;
        this._clusterName = zkPathKeys.get(0);
        this._participantName = type == ConfigScopeProperty.PARTICIPANT && this._isFullKey ? zkPathKeys.get(1) : null;
        this._zkPath = template.instantiate(type, zkPathKeys.toArray(new String[0]));
        this._mapKey = mapKey;
    }

    public ConfigScopeProperty getType() {
        return this._type;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getParticipantName() {
        return this._participantName;
    }

    public String getZkPath() {
        return this._zkPath;
    }

    public String getMapKey() {
        return this._mapKey;
    }

    public boolean isFullKey() {
        return this._isFullKey;
    }

    static {
        template.addEntry(ConfigScopeProperty.CLUSTER, 2, "/{clusterName}/CONFIGS/CLUSTER/{clusterName}");
        template.addEntry(ConfigScopeProperty.PARTICIPANT, 2, "/{clusterName}/CONFIGS/PARTICIPANT/{participantName}");
        template.addEntry(ConfigScopeProperty.RESOURCE, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}");
        template.addEntry(ConfigScopeProperty.PARTITION, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}");
        template.addEntry(ConfigScopeProperty.CLOUD, 2, "/{clusterName}/CONFIGS/CLOUD/{clusterName}");
        template.addEntry(ConfigScopeProperty.CLUSTER, 1, "/{clusterName}/CONFIGS/CLUSTER");
        template.addEntry(ConfigScopeProperty.PARTICIPANT, 1, "/{clusterName}/CONFIGS/PARTICIPANT");
        template.addEntry(ConfigScopeProperty.RESOURCE, 1, "/{clusterName}/CONFIGS/RESOURCE");
        template.addEntry(ConfigScopeProperty.REST, 2, "/{clusterName}/CONFIGS/REST/{clusterName}");
        template.addEntry(ConfigScopeProperty.CLOUD, 1, "/{clusterName}/CONFIGS/CLOUD");
        template.addEntry(ConfigScopeProperty.CUSTOMIZED_STATE_AGGREGATION, 2, "/{clusterName}/CONFIGS/CUSTOMIZED_STATE_AGGREGATION/{clusterName}");
        template.addEntry(ConfigScopeProperty.CUSTOMIZED_STATE, 2, "/{clusterName}/CONFIGS/CUSTOMIZED_STATE/{clusterName}");
    }

    public static enum ConfigScopeProperty {
        CLUSTER(2, 0),
        PARTICIPANT(2, 0),
        RESOURCE(2, 0),
        PARTITION(2, 1),
        CONSTRAINT(2, 0),
        REST(2, 0),
        CLOUD(2, 0),
        CUSTOMIZED_STATE_AGGREGATION(2, 0),
        CUSTOMIZED_STATE(2, 0);

        final int _zkPathArgNum;
        final int _mapKeyArgNum;

        private ConfigScopeProperty(int zkPathArgNum, int mapKeyArgNum) {
            this._zkPathArgNum = zkPathArgNum;
            this._mapKeyArgNum = mapKeyArgNum;
        }

        public int getZkPathArgNum() {
            return this._zkPathArgNum;
        }

        public int getMapKeyArgNum() {
            return this._mapKeyArgNum;
        }
    }
}

