ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,u,M){"use strict";var S=c("../lib/oop"),b=c("./text_highlight_rules").TextHighlightRules,f=u.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};u.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},u.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},u.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var p=u.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"},v=u.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/},l=u.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/},x=u.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/},s=u.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/},o=u.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/},n=u.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"},r=u.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},i=function(){var R=this.$keywords=this.createKeywordMapper({keyword:"alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend","constant.language":"true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION","variable.language":"$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|$!|root_url|flash|session|cookies|params|request|response|logger|self","support.function":"abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|validates_inclusion_of|validates_numericality_of|validates_with|validates_each|authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|cache|expire_fragment|expire_cache_for|observe|cache_sweeper|has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|private_class_method|remove_method|undef_method","invalid.deprecated":"debugger"},"identifier"),w="\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})",k={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:w},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:w},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(t,a,e){return e.length&&(e=[]),e.unshift(t[t.length-1],a),this.next="qStateWithoutInterpolation",this.token}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(t,a,e){return e.length&&(e=[]),e.unshift(t[t.length-1],a),this.next="qStateWithInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(t,a,e){return e.length&&(e=[]),e.unshift(t[t.length-1],a),this.next="sStateWithoutInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(t,a,e){return e.length&&(e=[]),e.unshift(t[t.length-1],a),this.next="sStateWithInterpolation",this.token}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(t,a,e){return e.length&&(e=[]),e.unshift(t[t.length-1],a),this.next="rState",this.token}}],{token:"punctuation",regex:"::"},r,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+w+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},s,o,f,p,n,v,l,x,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:R,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(t,a,e){var h="-"==t[2]||"~"==t[2]?"indentedHeredoc":"heredoc",d=t.split(this.splitRegex);return e.push(h,d[3]),[{type:"constant",value:d[1]},{type:"string",value:d[2]},{type:"support.class",value:d[3]},{type:"string",value:d[4]}]},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(t,a,e){return t===e[1]?(e.shift(),e.shift(),this.next=e[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(t,a,e){return t===e[1]?(e.shift(),e.shift(),this.next=e[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(t,a){return"heredoc"===a[0]||"indentedHeredoc"===a[0]?a[0]:t}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(t,a,e){return this.next="","}"==t&&e.length>1&&"start"!=e[1]&&(e.shift(),this.next=e.shift()),this.token}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],comment:[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],qStateWithInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(t,a,e){return e.length&&t===e[0]?(e.unshift(t,a),this.token):"string"}},{token:"constant.language.escape",regex:w},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(t,a,e){return e.length&&t===k[e[0]]?(e.shift(),this.next=e.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],qStateWithoutInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(t,a,e){return e.length&&t===e[0]?(e.unshift(t,a),this.token):"string"}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(t,a,e){return e.length&&t===k[e[0]]?(e.shift(),this.next=e.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],sStateWithoutInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(t,a,e){return e.length&&t===e[0]?(e.unshift(t,a),this.token):"constant.other.symbol.ruby"}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(t,a,e){return e.length&&t===k[e[0]]?(e.shift(),this.next=e.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],sStateWithInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(t,a,e){return e.length&&t===e[0]?(e.unshift(t,a),this.token):"constant.other.symbol.ruby"}},{token:"constant.language.escape",regex:w},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(t,a,e){return e.length&&t===k[e[0]]?(e.shift(),this.next=e.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],rState:[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(t,a,e){return e.length&&t===e[0]?(e.unshift(t,a),this.token):"constant.language.escape"}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(t,a,e){return e.length&&t[0]===k[e[0]]?(e.shift(),this.next=e.shift(),this.token):(this.next="","constant.language.escape")}},{include:"regex"},{defaultToken:"string.regexp"}],regex:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]},this.normalizeRules()};S.inherits(i,b),u.RubyHighlightRules=i}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(c,u,M){"use strict";var S=c("../range").Range,b=function(){};(function(){this.checkOutdent=function(f,p){return!!/^\s+$/.test(f)&&/^\s*\}/.test(p)},this.autoOutdent=function(f,p){var l=f.getLine(p).match(/^(\s*\})/);if(!l)return 0;var x=l[1].length,s=f.findMatchingBracket({row:p,column:x});if(!s||s.row==p)return 0;var o=this.$getIndent(f.getLine(s.row));f.replace(new S(p,0,p,x-1),o)},this.$getIndent=function(f){return f.match(/^\s*/)[0]}}).call(b.prototype),u.MatchingBraceOutdent=b}),ace.define("ace/mode/folding/ruby",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],function(c,u,M){"use strict";var S=c("../../lib/oop"),b=c("./fold_mode").FoldMode,f=c("../../range").Range,p=c("../../token_iterator").TokenIterator,v=u.FoldMode=function(){};S.inherits(v,b),function(){this.indentKeywords={class:1,def:1,module:1,do:1,unless:1,if:1,while:1,for:1,until:1,begin:1,else:0,elsif:0,rescue:0,ensure:0,when:0,end:-1,case:1,"=begin":1,"=end":-1},this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/,this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/,this.getFoldWidget=function(l,x,s){var i,o=l.getLine(s),n=this.foldingStartMarker.test(o),r=this.foldingStopMarker.test(o);if(n&&!r)if((i=o.match(this.foldingStartMarker))[1]){if(("if"==i[1]||"else"==i[1]||"while"==i[1]||"until"==i[1]||"unless"==i[1])&&("else"==i[1]&&!1===/^\s*else\s*$/.test(o)||!1===/^\s*(?:if|else|while|until|unless)\s*/.test(o))||"when"==i[1]&&!0===/\sthen\s/.test(o))return;if("keyword"===l.getTokenAt(s,i.index+2).type)return"start"}else{if(!i[3])return"start";if("comment.multiline"===l.getTokenAt(s,i.index+1).type)return"start"}if("markbeginend"!=x||!r||n&&r)return"";if("end"===(i=o.match(this.foldingStopMarker))[3]){if("keyword"===l.getTokenAt(s,i.index+1).type)return"end"}else{if(!i[1])return"end";if("comment.multiline"===l.getTokenAt(s,i.index+1).type)return"end"}},this.getFoldWidgetRange=function(l,x,s){var n,o=l.doc.getLine(s);return(n=this.foldingStartMarker.exec(o))?n[1]||n[3]?this.rubyBlock(l,s,n.index+2):this.openingBracketBlock(l,"{",s,n.index):(n=this.foldingStopMarker.exec(o))?"end"===n[3]&&"keyword"===l.getTokenAt(s,n.index+1).type||"=end"===n[1]&&"comment.multiline"===l.getTokenAt(s,n.index+1).type?this.rubyBlock(l,s,n.index+1):this.closingBracketBlock(l,"}",s,n.index+n[0].length):void 0},this.rubyBlock=function(l,d,s,o){var n=new p(l,d,s),r=n.getCurrentToken();if(r&&("keyword"==r.type||"comment.multiline"==r.type)){var i=r.value,_=l.getLine(d);switch(r.value){case"if":case"unless":case"while":case"until":if(!new RegExp("^\\s*"+r.value).test(_))return;var g=this.indentKeywords[i];break;case"when":if(/\sthen\s/.test(_))return;case"elsif":case"rescue":case"ensure":g=1;break;case"else":if(!new RegExp("^\\s*"+r.value+"\\s*$").test(_))return;g=1;break;default:g=this.indentKeywords[i]}var y=[i];if(g){var R=-1===g?l.getLine(d-1).length:l.getLine(d).length,w=d,k=[];if(k.push(n.getCurrentTokenRange()),n.step=-1===g?n.stepBackward:n.stepForward,"comment.multiline"==r.type){for(;r=n.step();)if("comment.multiline"===r.type)if(1==g){if(R=6,"=end"==r.value)break}else if("=begin"==r.value)break}else for(;r=n.step();){var t=!1;if("keyword"===r.type){var a=g*this.indentKeywords[r.value];switch(_=l.getLine(n.getCurrentTokenRow()),r.value){case"do":for(var e=n.$tokenIndex-1;e>=0;e--){var h=n.$rowTokens[e];if(h&&("while"==h.value||"until"==h.value||"for"==h.value)){a=0;break}}break;case"else":(!new RegExp("^\\s*"+r.value+"\\s*$").test(_)||"case"==i)&&(a=0,t=!0);break;case"if":case"unless":case"while":case"until":new RegExp("^\\s*"+r.value).test(_)||(a=0,t=!0);break;case"when":(/\sthen\s/.test(_)||"case"==i)&&(a=0,t=!0)}if(a>0)y.unshift(r.value);else if(a<=0&&!1===t){if(y.shift(),!y.length&&(("while"==i||"until"==i||"for"==i)&&"do"!=r.value||"do"==r.value&&-1==g&&0!=a||"do"!=r.value))break;0===a&&y.unshift(r.value)}}}if(!r)return null;if(o)return k.push(n.getCurrentTokenRange()),k;if(d=n.getCurrentTokenRow(),-1===g){if("comment.multiline"===r.type)var A=6;else A=l.getLine(d).length;return new f(d,A,w-1,R)}return new f(w,R,d-1,l.getLine(d-1).length)}}}}.call(v.prototype)}),ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/folding/ruby"],function(c,u,M){"use strict";var S=c("../lib/oop"),b=c("./text").Mode,f=c("./ruby_highlight_rules").RubyHighlightRules,p=c("./matching_brace_outdent").MatchingBraceOutdent,v=c("../range").Range,l=c("./folding/ruby").FoldMode,x=function(){this.HighlightRules=f,this.$outdent=new p,this.$behaviour=this.$defaultBehaviour,this.foldingRules=new l,this.indentKeywords=this.foldingRules.indentKeywords};S.inherits(x,b),function(){this.lineCommentStart="#",this.getNextLineIndent=function(s,o,n){var r=this.$getIndent(o),_=this.getTokenizer().getLineTokens(o,s).tokens;if(_.length&&"comment"==_[_.length-1].type)return r;if("start"==s){var m=o.match(/^.*[\{\(\[]\s*$/),g=o.match(/^\s*(class|def|module)\s.*$/),y=o.match(/.*do(\s*|\s+\|.*\|\s*)$/),R=o.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);(m||g||y||R)&&(r+=n)}return r},this.checkOutdent=function(s,o,n){return/^\s+(end|else|rescue|ensure)$/.test(o+n)||this.$outdent.checkOutdent(o,n)},this.autoOutdent=function(s,o,n){var r=o.getLine(n);if(/}/.test(r))return this.$outdent.autoOutdent(o,n);var i=this.$getIndent(r),_=o.getLine(n-1),m=this.$getIndent(_),g=o.getTabString();m.length<=i.length&&i.slice(-g.length)==g&&o.remove(new v(n,i.length-g.length,n,i.length))},this.getMatching=function(s,o,n){if(null==o){var r=s.selection.lead;n=r.column,o=r.row}var i=s.getTokenAt(o,n);if(i&&i.value in this.indentKeywords)return this.foldingRules.rubyBlock(s,o,n,!0)},this.$id="ace/mode/ruby",this.snippetFileId="ace/snippets/ruby"}.call(x.prototype),u.Mode=x}),ace.require(["ace/mode/ruby"],function(c){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=c)});