/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.metrics.implementation;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.rebalancer.util.ResourceUsageCalculator;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.metrics.model.RatioMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaselineDivergenceGauge
extends RatioMetric {
    private static final Logger LOG = LoggerFactory.getLogger(BaselineDivergenceGauge.class);

    public BaselineDivergenceGauge(String metricName) {
        super(metricName, 0.0);
    }

    public void asyncMeasureAndUpdateValue(ExecutorService threadPool, Map<String, ResourceAssignment> baseline, Map<String, ResourceAssignment> bestPossibleAssignment) {
        AbstractBaseStage.asyncExecute(threadPool, () -> {
            try {
                double baselineDivergence = ResourceUsageCalculator.measureBaselineDivergence(baseline, bestPossibleAssignment);
                this.updateValue(baselineDivergence);
            }
            catch (Exception e) {
                LOG.error("Failed to report BaselineDivergenceGauge metric.", (Throwable)e);
            }
            return null;
        });
    }
}

