/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.common;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.RESTConfig;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.helix.rest.client.CustomRestClientFactory;
import org.apache.helix.rest.common.RestSnapShotSimpleImpl;
import org.apache.helix.rest.common.datamodel.RestSnapShot;
import org.apache.helix.rest.server.service.InstanceService;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixDataAccessorWrapper
extends ZKHelixDataAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(HelixDataAccessorWrapper.class);
    private static final ExecutorService POOL = Executors.newCachedThreadPool();
    public static final String PARTITION_HEALTH_KEY = "PARTITION_HEALTH";
    public static final String IS_HEALTHY_KEY = "IS_HEALTHY";
    public static final String EXPIRY_KEY = "EXPIRE";
    private static final String CUSTOM_PARTITION_CHECK_HTTP_REQUESTS_ERROR_TOTAL = MetricRegistry.name(InstanceService.class, (String[])new String[]{"custom_partition_check_http_requests_error_total"});
    private static final String CUSTOM_PARTITION_CHECK_HTTP_REQUESTS_DURATION = MetricRegistry.name(InstanceService.class, (String[])new String[]{"custom_partition_check_http_requests_duration"});
    protected String _namespace;
    protected CustomRestClient _restClient;
    private RestSnapShotSimpleImpl _restSnapShot;

    @Deprecated
    public HelixDataAccessorWrapper(ZKHelixDataAccessor dataAccessor) {
        this(dataAccessor, CustomRestClientFactory.get(), "default");
    }

    @Deprecated
    public HelixDataAccessorWrapper(ZKHelixDataAccessor dataAccessor, CustomRestClient customRestClient) {
        this(dataAccessor, customRestClient, "default");
    }

    public HelixDataAccessorWrapper(ZKHelixDataAccessor dataAccessor, CustomRestClient customRestClient, String namespace) {
        super(dataAccessor);
        this._restClient = customRestClient;
        this._namespace = namespace;
        this._restSnapShot = new RestSnapShotSimpleImpl(this._clusterName);
    }

    public Map<String, Map<String, Boolean>> getAllPartitionsHealthOnLiveInstance(RESTConfig restConfig, Map<String, String> customPayLoads) {
        return this.getAllPartitionsHealthOnLiveInstance(restConfig, customPayLoads, false);
    }

    public Map<String, Map<String, Boolean>> getAllPartitionsHealthOnLiveInstance(RESTConfig restConfig, Map<String, String> customPayLoads, boolean skipZKRead) {
        List<String> liveInstances = this.getChildNames(this.keyBuilder().liveInstances());
        List zkHealthReports = !skipZKRead ? this.getProperty(liveInstances.stream().map(instance -> this.keyBuilder().healthReport(instance, PARTITION_HEALTH_KEY)).collect(Collectors.toList()), false) : liveInstances.stream().map(instance -> new HelixProperty(instance)).collect(Collectors.toList());
        HashMap<String, Future<Map>> parallelTasks = new HashMap<String, Future<Map>>();
        for (int i = 0; i < liveInstances.size(); ++i) {
            String liveInstance = liveInstances.get(i);
            Optional<ZNRecord> maybeHealthRecord = Optional.ofNullable(zkHealthReports.get(i)).map(HelixProperty::getRecord);
            parallelTasks.put(liveInstance, POOL.submit(() -> maybeHealthRecord.map(record -> this.getPartitionsHealthFromCustomAPI(liveInstance, (ZNRecord)record, restConfig, customPayLoads, skipZKRead)).orElseGet(() -> this.getHealthStatusFromRest(liveInstance, Collections.emptyList(), restConfig, customPayLoads))));
        }
        HashMap<String, Map<String, Boolean>> result = new HashMap<String, Map<String, Boolean>>();
        for (Map.Entry instanceToFuturePartitionHealth : parallelTasks.entrySet()) {
            String instance2 = (String)instanceToFuturePartitionHealth.getKey();
            try {
                result.put(instance2, (Map<String, Boolean>)((Future)instanceToFuturePartitionHealth.getValue()).get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Failed to get partition health for instance {}", (Object)instance2, (Object)e);
                result.put(instance2, Collections.emptyMap());
            }
        }
        return result;
    }

    private Map<String, Boolean> getPartitionsHealthFromCustomAPI(String instance, ZNRecord partitionHealthRecord, RESTConfig restConfig, Map<String, String> customPayLoads, boolean requireFullRead) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ArrayList<String> expiredPartitions = new ArrayList<String>();
        for (String partitionName : partitionHealthRecord.getMapFields().keySet()) {
            Map healthMap = partitionHealthRecord.getMapField(partitionName);
            if (healthMap == null || Long.parseLong((String)healthMap.get(EXPIRY_KEY)) < System.currentTimeMillis()) {
                expiredPartitions.add(partitionName);
                continue;
            }
            result.put(partitionName, Boolean.valueOf((String)healthMap.get(IS_HEALTHY_KEY)));
        }
        if (requireFullRead) {
            result.putAll(this.getHealthStatusFromRest(instance, null, restConfig, customPayLoads));
        } else if (!expiredPartitions.isEmpty()) {
            result.putAll(this.getHealthStatusFromRest(instance, expiredPartitions, restConfig, customPayLoads));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Boolean> getHealthStatusFromRest(String instance, List<String> partitions, RESTConfig restConfig, Map<String, String> customPayLoads) {
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)this._namespace);
        try (Timer.Context timer = metrics.timer(CUSTOM_PARTITION_CHECK_HTTP_REQUESTS_DURATION).time();){
            Map<String, Boolean> map = this._restClient.getPartitionStoppableCheck(restConfig.getBaseUrl(instance), partitions, customPayLoads);
            return map;
        }
        catch (IOException e) {
            LOG.error("Failed to get partition status on instance {}, partitions: {}", new Object[]{instance, partitions, e});
            metrics.counter(CUSTOM_PARTITION_CHECK_HTTP_REQUESTS_ERROR_TOTAL).inc();
            return Collections.emptyMap();
        }
    }

    public RestSnapShot getRestSnapShot() {
        return this._restSnapShot;
    }

    public <T extends HelixProperty> T getProperty(PropertyKey key) {
        Object property = this._restSnapShot.getProperty(key);
        if (property == null) {
            property = super.getProperty(key);
            this._restSnapShot.updateValue(key, property);
        }
        return property;
    }

    public List<String> getChildNames(PropertyKey key) {
        List names = this._restSnapShot.getChildNames(key);
        if (names == null) {
            names = super.getChildNames(key);
            this._restSnapShot.updateChildNames(key, names);
        }
        return names;
    }

    public void fetchIdealStatesExternalViewStateModel() {
        PropertyKey.Builder propertyKeyBuilder = this.keyBuilder();
        List<String> resources = this.getChildNames(propertyKeyBuilder.idealStates());
        for (String resourceName : resources) {
            this.getProperty(propertyKeyBuilder.idealStates(resourceName));
            ExternalView externalView = (ExternalView)this.getProperty(propertyKeyBuilder.externalView(resourceName));
            if (externalView == null) continue;
            String stateModeDef = externalView.getStateModelDefRef();
            this.getProperty(propertyKeyBuilder.stateModelDef(stateModeDef));
        }
        this._restSnapShot.addPropertyType(PropertyType.IDEALSTATES);
        this._restSnapShot.addPropertyType(PropertyType.EXTERNALVIEW);
        this._restSnapShot.addPropertyType(PropertyType.STATEMODELDEFS);
    }

    public void populateCache(List<PropertyType> propertyTypes) {
        block3: for (PropertyType propertyType : propertyTypes) {
            switch (propertyType) {
                case IDEALSTATES: 
                case EXTERNALVIEW: 
                case STATEMODELDEFS: {
                    if (this._restSnapShot.containsProperty(propertyType)) continue block3;
                    this.fetchIdealStatesExternalViewStateModel();
                    continue block3;
                }
            }
            throw new UnsupportedOperationException("type selection is not supported yet!");
        }
    }
}

