/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.task.TaskConstants;
import org.apache.helix.task.TaskState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowContext
extends HelixProperty {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowContext.class);
    public static final int NOT_STARTED = -1;
    public static final int UNFINISHED = -1;
    private boolean isModified = false;
    private static final int SCHEDULED_WORKFLOW_HISTORY_SIZE = 20;

    public WorkflowContext(ZNRecord record) {
        super(record);
    }

    public void setWorkflowState(TaskState s) {
        TaskState workflowState = this.getWorkflowState();
        if (!TaskConstants.FINAL_STATES.contains((Object)workflowState) && !s.equals((Object)workflowState)) {
            this._record.setSimpleField(WorkflowContextProperties.STATE.name(), s.name());
            this.markWorkflowContextAsModified();
        }
    }

    public TaskState getWorkflowState() {
        String state = this._record.getSimpleField(WorkflowContextProperties.STATE.name());
        if (state == null) {
            return TaskState.NOT_STARTED;
        }
        return TaskState.valueOf(state);
    }

    public void setJobState(String job, TaskState s) {
        Map<String, String> states = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (states == null) {
            states = new TreeMap<String, String>();
            this._record.setMapField(WorkflowContextProperties.JOB_STATES.name(), states);
        }
        if (!s.name().equals(states.get(job))) {
            states.put(job, s.name());
            this.markWorkflowContextAsModified();
        }
    }

    protected void removeJobStates(Set<String> jobs) {
        Map<String, String> states = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (states != null) {
            if (states.keySet().stream().anyMatch(jobs::contains)) {
                states.keySet().removeAll(jobs);
                this._record.setMapField(WorkflowContextProperties.JOB_STATES.name(), states);
                this.markWorkflowContextAsModified();
            }
        }
    }

    public TaskState getJobState(String job) {
        Map<String, String> states = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (states == null) {
            return null;
        }
        String s = states.get(job);
        if (s == null) {
            return null;
        }
        return TaskState.valueOf(s);
    }

    protected void setJobStartTime(String job, long time) {
        Map<String, String> startTimes = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimes == null) {
            startTimes = new HashMap<String, String>();
            this._record.setMapField(WorkflowContextProperties.StartTime.name(), startTimes);
            this.markWorkflowContextAsModified();
        }
        if (!String.valueOf(time).equals(startTimes.get(job))) {
            startTimes.put(job, String.valueOf(time));
            this.markWorkflowContextAsModified();
        }
    }

    protected void removeJobStartTime(Set<String> jobs) {
        Map<String, String> startTimes = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimes != null) {
            if (startTimes.keySet().stream().anyMatch(jobs::contains)) {
                startTimes.keySet().removeAll(jobs);
                this._record.setMapField(WorkflowContextProperties.StartTime.name(), startTimes);
                this.markWorkflowContextAsModified();
            }
        }
    }

    public long getJobStartTime(String job) {
        Map<String, String> startTimes = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimes == null || !startTimes.containsKey(job)) {
            return -1L;
        }
        String t = startTimes.get(job);
        if (t == null) {
            return -1L;
        }
        try {
            long ret = Long.valueOf(t);
            return ret;
        }
        catch (NumberFormatException e) {
            LOG.warn("Number error {} for job start time of {}.", new Object[]{t, job, e});
            return -1L;
        }
    }

    public Map<String, Long> getJobStartTimes() {
        HashMap<String, Long> startTimes = new HashMap<String, Long>();
        Map<String, String> startTimesMap = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimesMap != null) {
            for (Map.Entry<String, String> time : startTimesMap.entrySet()) {
                startTimes.put(time.getKey(), Long.valueOf(time.getValue()));
            }
        }
        return startTimes;
    }

    public Map<String, TaskState> getJobStates() {
        HashMap<String, TaskState> jobStates = new HashMap<String, TaskState>();
        Map<String, String> stateFieldMap = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (stateFieldMap != null) {
            for (Map.Entry<String, String> state : stateFieldMap.entrySet()) {
                jobStates.put(state.getKey(), TaskState.valueOf(state.getValue()));
            }
        }
        return jobStates;
    }

    public void setStartTime(long t) {
        long workflowStartTime = this.getStartTime();
        if (workflowStartTime == -1L || workflowStartTime != t) {
            this._record.setSimpleField(WorkflowContextProperties.START_TIME.name(), String.valueOf(t));
            this.markWorkflowContextAsModified();
        }
    }

    public long getStartTime() {
        String tStr = this._record.getSimpleField(WorkflowContextProperties.START_TIME.name());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setFinishTime(long t) {
        long workflowFinishTime = this.getFinishTime();
        if (workflowFinishTime == -1L || workflowFinishTime != t) {
            this._record.setSimpleField(WorkflowContextProperties.FINISH_TIME.name(), String.valueOf(t));
            this.markWorkflowContextAsModified();
        }
    }

    public long getFinishTime() {
        String tStr = this._record.getSimpleField(WorkflowContextProperties.FINISH_TIME.name());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setLastScheduledSingleWorkflow(String workflow) {
        List<String> scheduledWorkflows;
        String lastScheduleWorkflow = this._record.getSimpleField(WorkflowContextProperties.LAST_SCHEDULED_WORKFLOW.name());
        if (!workflow.equals(lastScheduleWorkflow)) {
            this._record.setSimpleField(WorkflowContextProperties.LAST_SCHEDULED_WORKFLOW.name(), workflow);
            this.markWorkflowContextAsModified();
        }
        if ((scheduledWorkflows = this.getScheduledWorkflows()) == null) {
            scheduledWorkflows = new ArrayList<String>();
            this._record.setListField(WorkflowContextProperties.SCHEDULED_WORKFLOWS.name(), scheduledWorkflows);
        }
        if (!scheduledWorkflows.contains(workflow)) {
            while (scheduledWorkflows.size() >= 20) {
                scheduledWorkflows.remove(0);
            }
            scheduledWorkflows.add(workflow);
            this.markWorkflowContextAsModified();
        }
    }

    public String getLastScheduledSingleWorkflow() {
        return this._record.getSimpleField(WorkflowContextProperties.LAST_SCHEDULED_WORKFLOW.name());
    }

    protected void setLastJobPurgeTime(long epochTime) {
        long lastPurgeTime = this.getLastJobPurgeTime();
        if (lastPurgeTime == -1L || lastPurgeTime == epochTime) {
            this._record.setSimpleField(WorkflowContextProperties.LAST_PURGE_TIME.name(), String.valueOf(epochTime));
            this.markWorkflowContextAsModified();
        }
    }

    public long getLastJobPurgeTime() {
        return this._record.getLongField(WorkflowContextProperties.LAST_PURGE_TIME.name(), -1L);
    }

    public List<String> getScheduledWorkflows() {
        return this._record.getListField(WorkflowContextProperties.SCHEDULED_WORKFLOWS.name());
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (!name.equals(oldName)) {
            this._record.setSimpleField(WorkflowContextProperties.NAME.name(), name);
            this.markWorkflowContextAsModified();
        }
    }

    public String getName() {
        return this._record.getSimpleField(WorkflowContextProperties.NAME.name());
    }

    public void markWorkflowContextAsModified() {
        this.isModified = true;
    }

    public boolean isWorkflowContextModified() {
        return this.isModified;
    }

    protected static enum WorkflowContextProperties {
        STATE,
        START_TIME,
        FINISH_TIME,
        JOB_STATES,
        LAST_SCHEDULED_WORKFLOW,
        SCHEDULED_WORKFLOWS,
        LAST_PURGE_TIME,
        StartTime,
        NAME;

    }
}

