/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantHistory
extends HelixProperty {
    private static Logger LOG = LoggerFactory.getLogger(ParticipantHistory.class);
    private static final String UNKNOWN_HOST_NAME = "UnknownHostname";
    private static final int HISTORY_SIZE = 20;
    private static final String HISTORY_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss:SSS";
    public static long ONLINE = -1L;

    public ParticipantHistory(String id) {
        super(id);
    }

    public ParticipantHistory(ZNRecord znRecord) {
        super(znRecord);
    }

    public void reportOffline() {
        long time = System.currentTimeMillis();
        this._record.setSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name(), String.valueOf(time));
        this.updateOfflineHistory(time);
    }

    public void reportOnline(String sessionId, String version) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to get host name. Use {} for the participant history recording.", (Object)UNKNOWN_HOST_NAME);
            hostname = UNKNOWN_HOST_NAME;
        }
        this.updateSessionHistory(sessionId, version, hostname);
        this._record.setSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name(), String.valueOf(ONLINE));
    }

    public long getLastOfflineTime() {
        long offlineTime = ONLINE;
        String timeStr = this._record.getSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name());
        if (timeStr != null) {
            try {
                offlineTime = Long.valueOf(timeStr);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Failed to parse LAST_OFFLINE_TIME " + timeStr);
            }
        }
        return offlineTime;
    }

    public long getLastTimeInOfflineHistory() {
        List<String> offlineHistory = this._record.getListField(ConfigProperty.OFFLINE.name());
        if (offlineHistory == null || offlineHistory.isEmpty()) {
            return -1L;
        }
        String lastDate = offlineHistory.get(offlineHistory.size() - 1);
        return ParticipantHistory.historyDateStringToLong(lastDate);
    }

    private void updateSessionHistory(String sessionId, String version, String hostname) {
        List<String> list = this._record.getListField(ConfigProperty.HISTORY.name());
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(ConfigProperty.HISTORY.name(), list);
        }
        if (list.size() == 20) {
            list.remove(0);
        }
        HashMap<String, String> sessionEntry = new HashMap<String, String>();
        sessionEntry.put(ConfigProperty.SESSION.name(), sessionId);
        long timeMillis = System.currentTimeMillis();
        sessionEntry.put(ConfigProperty.TIME.name(), String.valueOf(timeMillis));
        sessionEntry.put(ConfigProperty.DATE.name(), ParticipantHistory.historyDateLongToString(timeMillis));
        sessionEntry.put(ConfigProperty.VERSION.name(), version);
        sessionEntry.put(ConfigProperty.HOST.name(), hostname);
        list.add(((Object)sessionEntry).toString());
    }

    private void updateOfflineHistory(long time) {
        List<String> list = this._record.getListField(ConfigProperty.OFFLINE.name());
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(ConfigProperty.OFFLINE.name(), list);
        }
        if (list.size() == 20) {
            list.remove(0);
        }
        list.add(ParticipantHistory.historyDateLongToString(time));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private static long historyDateStringToLong(String dateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HISTORY_DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date date = simpleDateFormat.parse(dateString);
            return date.getTime();
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse participant history date string: " + dateString);
            return -1L;
        }
    }

    private static String historyDateLongToString(long dateLong) {
        SimpleDateFormat df = new SimpleDateFormat(HISTORY_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date(dateLong));
    }

    public static Map<String, String> sessionHistoryStringToMap(String sessionHistoryString) {
        sessionHistoryString = sessionHistoryString.substring(1, sessionHistoryString.length() - 1);
        HashMap<String, String> sessionHistoryMap = new HashMap<String, String>();
        for (String sessionHistoryKeyValuePair : sessionHistoryString.split(", ")) {
            String[] keyValuePair = sessionHistoryKeyValuePair.split("=");
            if (keyValuePair.length < 2) {
                LOG.warn("Ignore key value pair while parsing session history due to missing '=': " + sessionHistoryKeyValuePair);
                continue;
            }
            sessionHistoryMap.put(keyValuePair[0], keyValuePair[1]);
        }
        return sessionHistoryMap;
    }

    private static long getTimeFromSessionHistoryString(String sessionHistoryString) {
        Map<String, String> sessionHistoryMap = ParticipantHistory.sessionHistoryStringToMap(sessionHistoryString);
        if (!sessionHistoryMap.containsKey(ConfigProperty.TIME.name())) {
            return -1L;
        }
        try {
            return Long.parseLong(sessionHistoryMap.get(ConfigProperty.TIME.name()));
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse TIME field to long: " + sessionHistoryMap.get(ConfigProperty.TIME.name()));
            return -1L;
        }
    }

    public List<Long> getOnlineTimestampsAsMilliseconds() {
        List<String> historyList = this.getRecord().getListField(ConfigProperty.HISTORY.name());
        if (historyList == null) {
            return Collections.emptyList();
        }
        return historyList.stream().map(ParticipantHistory::getTimeFromSessionHistoryString).filter(result -> result != -1L).collect(Collectors.toList());
    }

    public List<Long> getOfflineTimestampsAsMilliseconds() {
        List<String> offlineList = this.getRecord().getListField(ConfigProperty.OFFLINE.name());
        if (offlineList == null) {
            return Collections.emptyList();
        }
        return offlineList.stream().map(ParticipantHistory::historyDateStringToLong).filter(result -> result != -1L).collect(Collectors.toList());
    }

    static enum ConfigProperty {
        TIME,
        DATE,
        SESSION,
        HISTORY,
        OFFLINE,
        VERSION,
        LAST_OFFLINE_TIME,
        HOST;

    }
}

