/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRollbackException;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.handling.CurrentStateUpdate;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.task.TaskStateModel;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.ZNRecordBucketizer;
import org.apache.helix.zookeeper.datamodel.ZNRecordDelta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixStateTransitionHandler
extends MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(HelixStateTransitionHandler.class);
    private final StateModel _stateModel;
    StatusUpdateUtil _statusUpdateUtil;
    private final StateModelParser _transitionMethodFinder;
    private final CurrentState _currentStateDelta;
    private final HelixManager _manager;
    private final StateModelFactory<? extends StateModel> _stateModelFactory;
    private final boolean _isTaskMessage;
    private final boolean _isTaskCurrentStatePathDisabled;
    volatile boolean _isTimeout = false;

    public HelixStateTransitionHandler(StateModelFactory<? extends StateModel> stateModelFactory, StateModel stateModel, Message message, NotificationContext context, CurrentState currentStateDelta) {
        super(message, context);
        this._stateModel = stateModel;
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._transitionMethodFinder = new StateModelParser();
        this._currentStateDelta = currentStateDelta;
        this._manager = this._notificationContext.getManager();
        this._stateModelFactory = stateModelFactory;
        this._isTaskMessage = stateModel instanceof TaskStateModel;
        this._isTaskCurrentStatePathDisabled = Boolean.getBoolean("helix.taskCurrentStatePathDisabled");
    }

    void preHandleMessage() throws Exception {
        if (!this._message.isValid()) {
            String errorMessage = "Invalid Message, ensure that message: " + this._message + " has all the required fields: " + Arrays.toString((Object[])Message.Attributes.values());
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, errorMessage, this._manager);
            logger.error(errorMessage);
            throw new HelixException(errorMessage);
        }
        logger.info("handling message: " + this._message.getMsgId() + " transit " + this._message.getResourceName() + "." + this._message.getPartitionName() + "|" + this._message.getPartitionNames() + " from:" + this._message.getFromState() + " to:" + this._message.getToState() + ", relayedFrom: " + this._message.getRelaySrcHost());
        this._currentStateDelta.setStartTime(this._message.getPartitionName(), System.currentTimeMillis());
        StaleMessageValidateResult err = this.staleMessageValidator();
        if (!err.isValid) {
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, err.exception.getMessage(), this._manager);
            logger.error(err.exception.getMessage());
            throw err.exception;
        }
    }

    void postHandleMessage() {
        HelixTaskResult taskResult = (HelixTaskResult)this._notificationContext.get(NotificationContext.MapKey.HELIX_TASK_RESULT.toString());
        Exception exception = taskResult.getException();
        String partitionKey = this._message.getPartitionName();
        if (!this._message.getTgtSessionId().equals(this._manager.getSessionId())) {
            logger.warn("Session id has changed. Skip postExecutionMessage. Old session " + this._message.getExecutionSessionId() + " , new session : " + this._manager.getSessionId());
            return;
        }
        this._currentStateDelta.setInfo(partitionKey, taskResult.getInfo());
        this._currentStateDelta.setEndTime(partitionKey, taskResult.getCompleteTime());
        this._currentStateDelta.setPreviousState(partitionKey, this._message.getFromState());
        this._currentStateDelta.setTriggerHost(partitionKey, Message.MessageType.RELAYED_MESSAGE.name().equals(this._message.getMsgSubType()) ? this._message.getRelaySrcHost() : this._message.getMsgSrc());
        if (taskResult.isSuccess()) {
            String toState = this._message.getToState();
            this._currentStateDelta.setState(partitionKey, toState);
            if (toState.equalsIgnoreCase(HelixDefinedState.DROPPED.toString())) {
                ZNRecord rec = new ZNRecord(this._currentStateDelta.getId());
                rec.getMapFields().put(partitionKey, null);
                ZNRecordDelta delta = new ZNRecordDelta(rec, ZNRecordDelta.MergeOperation.SUBTRACT);
                ArrayList<ZNRecordDelta> deltaList = new ArrayList<ZNRecordDelta>();
                deltaList.add(delta);
                this._currentStateDelta.setDeltaList(deltaList);
                this._stateModelFactory.removeStateModel(this._message.getResourceName(), partitionKey);
            } else if (this._stateModel.getCurrentState().equals(this._message.getFromState())) {
                this._stateModel.updateState(toState);
            }
        } else if (!taskResult.isCancelled()) {
            if (exception instanceof HelixStateMismatchException) {
                logger.warn("Force CurrentState on Zk to be stateModel's CurrentState. partitionKey: " + partitionKey + ", currentState: " + this._stateModel.getCurrentState() + ", message: " + this._message);
                this._currentStateDelta.setState(partitionKey, this._stateModel.getCurrentState());
                this.updateZKCurrentState();
                return;
            }
            if (exception instanceof InterruptedException && !this._isTimeout) {
                logger.error("State transition interrupted but not timeout. Not updating state. Partition : " + this._message.getPartitionName() + " MsgId : " + this._message.getMsgId());
                return;
            }
            StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, exception instanceof InterruptedException ? MessageHandler.ErrorCode.TIMEOUT : MessageHandler.ErrorCode.ERROR, exception);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
            this._currentStateDelta.setState(partitionKey, HelixDefinedState.ERROR.toString());
            this._stateModel.updateState(HelixDefinedState.ERROR.toString());
        }
        this.updateZKCurrentState();
    }

    private void updateZKCurrentState() {
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        String partitionKey = this._message.getPartitionName();
        String resource = this._message.getResourceName();
        String sessionId = this._message.getTgtSessionId();
        String instanceName = this._manager.getInstanceName();
        try {
            PropertyKey key;
            if (!this._stateModel.getCurrentState().equals(this._currentStateDelta.getState(partitionKey)) && !this._currentStateDelta.getState(partitionKey).equalsIgnoreCase(HelixDefinedState.DROPPED.toString())) {
                logger.warn("_stateModel is already updated by TaskRunner. Skip ZK update in StateTransitionHandler");
                return;
            }
            int bucketSize = this._message.getBucketSize();
            ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(bucketSize);
            PropertyKey propertyKey = key = this._isTaskMessage && !this._isTaskCurrentStatePathDisabled ? accessor.keyBuilder().taskCurrentState(instanceName, sessionId, resource, bucketizer.getBucketName(partitionKey)) : accessor.keyBuilder().currentState(instanceName, sessionId, resource, bucketizer.getBucketName(partitionKey));
            if (this._message.getAttribute(Message.Attributes.PARENT_MSG_ID) == null) {
                if (!accessor.updateProperty(key, this._currentStateDelta)) {
                    throw new HelixException("Fails to persist current state back to ZK for resource " + resource + " partition: " + this._message.getPartitionName());
                }
            } else {
                ConcurrentHashMap csUpdateMap = (ConcurrentHashMap)this._notificationContext.get(NotificationContext.MapKey.CURRENT_STATE_UPDATE.toString());
                csUpdateMap.put(partitionKey, new CurrentStateUpdate(key, this._currentStateDelta));
            }
        }
        catch (Exception e) {
            logger.error("Error when updating current-state ", (Throwable)e);
            StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.FRAMEWORK, MessageHandler.ErrorCode.ERROR, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, e, "Error when update current-state ", this._manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixTaskResult handleMessage() {
        NotificationContext context = this._notificationContext;
        Message message = this._message;
        HelixTaskResult taskResult = new HelixTaskResult();
        HelixManager manager = context.getManager();
        this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling task begin execute", manager);
        message.setExecuteStartTimeStamp(System.currentTimeMillis());
        try {
            this.preHandleMessage();
            this.invoke(manager, context, taskResult, message);
        }
        catch (HelixDuplicatedStateTransitionException e) {
            taskResult.setSuccess(true);
            taskResult.setMessage(e.toString());
            taskResult.setInfo(e.getMessage());
        }
        catch (HelixStateMismatchException e) {
            taskResult.setSuccess(false);
            taskResult.setMessage(e.toString());
            taskResult.setException(e);
        }
        catch (Exception e2) {
            InterruptedException e2;
            String errorMessage = "Exception while executing a state transition task " + message.getPartitionName();
            logger.error(errorMessage, (Throwable)e2);
            if (e2.getCause() != null && e2.getCause() instanceof InterruptedException) {
                e2 = (InterruptedException)e2.getCause();
            }
            if (e2 instanceof HelixRollbackException || e2.getCause() != null && e2.getCause() instanceof HelixRollbackException) {
                logger.info("Rollback happened of state transition on resource \"" + this._message.getResourceName() + "\" partition \"" + this._message.getPartitionName() + "\" from \"" + this._message.getFromState() + "\" to \"" + this._message.getToState() + "\"");
                taskResult.setCancelled(true);
            }
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, (Exception)e2, errorMessage, manager);
            taskResult.setSuccess(false);
            taskResult.setMessage(e2.toString());
            taskResult.setException(e2);
            taskResult.setInterrupted(e2 instanceof InterruptedException);
        }
        taskResult.setCompleteTime(System.currentTimeMillis());
        context.add(NotificationContext.MapKey.HELIX_TASK_RESULT.toString(), taskResult);
        StateModel stateModel = this._stateModel;
        synchronized (stateModel) {
            this.postHandleMessage();
        }
        return taskResult;
    }

    private void invoke(HelixManager manager, NotificationContext context, HelixTaskResult taskResult, Message message) throws IllegalAccessException, InvocationTargetException, InterruptedException, HelixRollbackException {
        this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling invoking", manager);
        Method methodToInvoke = null;
        String fromState = message.getFromState();
        String toState = message.getToState();
        methodToInvoke = this._transitionMethodFinder.getMethodForTransition(this._stateModel.getClass(), fromState, toState, new Class[]{Message.class, NotificationContext.class});
        if (methodToInvoke != null) {
            logger.info(String.format("Instance %s, partition %s received state transition from %s to %s on session %s, message id: %s", message.getTgtName(), message.getPartitionName(), message.getFromState(), message.getToState(), message.getTgtSessionId(), message.getMsgId()));
            if (this._cancelled) {
                throw new HelixRollbackException(String.format("Instance %s, partition %s state transition from %s to %s on session %s has been cancelled, message id: %s", message.getTgtName(), message.getPartitionName(), message.getFromState(), message.getToState(), message.getTgtSessionId(), message.getMsgId()));
            }
            Object result = methodToInvoke.invoke((Object)this._stateModel, message, context);
            taskResult.setSuccess(true);
            String resultStr = result == null || result instanceof Void ? "" : result.toString();
            taskResult.setInfo(resultStr);
        } else {
            String errorMessage = "Unable to find method for transition from " + fromState + " to " + toState + " in " + this._stateModel.getClass();
            logger.error(errorMessage);
            taskResult.setSuccess(false);
            taskResult.setInfo(errorMessage);
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, errorMessage, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String instanceName = this._manager.getInstanceName();
        String resourceName = this._message.getResourceName();
        String partition = this._message.getPartitionName();
        if (type == MessageHandler.ErrorType.INTERNAL) {
            logger.error("Skip internal error. errCode: " + (Object)((Object)code) + ", errMsg: " + e.getMessage());
            return;
        }
        try {
            if (code == MessageHandler.ErrorCode.ERROR) {
                PropertyKey currentStateKey;
                CurrentState currentStateDelta = new CurrentState(resourceName);
                currentStateDelta.setState(partition, HelixDefinedState.ERROR.toString());
                this._stateModel.updateState(HelixDefinedState.ERROR.toString());
                PropertyKey propertyKey = currentStateKey = this._isTaskMessage && !this._isTaskCurrentStatePathDisabled ? keyBuilder.taskCurrentState(instanceName, this._message.getTgtSessionId(), resourceName) : keyBuilder.currentState(instanceName, this._message.getTgtSessionId(), resourceName);
                if (!accessor.updateProperty(currentStateKey, currentStateDelta)) {
                    logger.error("Fails to persist ERROR current state to ZK for resource " + resourceName + " partition: " + partition);
                }
            }
        }
        finally {
            StateTransitionError error = new StateTransitionError(type, code, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
        }
    }

    public StaleMessageValidateResult staleMessageValidator() {
        String fromState = this._message.getFromState();
        String toState = this._message.getToState();
        String partitionName = this._message.getPartitionName();
        String state = this._currentStateDelta.getState(partitionName);
        Exception err = null;
        if (toState.equalsIgnoreCase(state)) {
            err = new HelixDuplicatedStateTransitionException(String.format("Partition %s current state is same as toState (%s->%s) from message.", partitionName, fromState, toState));
        } else if (fromState != null && !fromState.equals("*") && !fromState.equalsIgnoreCase(state)) {
            err = new HelixStateMismatchException(String.format("Current state of stateModel does not match the fromState in Message, CurrentState: %s, Message: %s->%s, Partition: %s, from: %s, to: %s", state, fromState, toState, partitionName, this._message.getMsgSrc(), this._message.getTgtName()));
        }
        return new StaleMessageValidateResult(err);
    }

    @Override
    public void onTimeout() {
        this._isTimeout = true;
    }

    public static class StaleMessageValidateResult {
        public boolean isValid;
        public Exception exception;

        StaleMessageValidateResult(Exception exp) {
            this.exception = exp;
            this.isValid = this.exception == null;
        }
    }

    public static class HelixDuplicatedStateTransitionException
    extends Exception {
        public HelixDuplicatedStateTransitionException(String info) {
            super(info);
        }
    }

    public static class HelixStateMismatchException
    extends Exception {
        public HelixStateMismatchException(String info) {
            super(info);
        }
    }
}

