/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.participant.statemachine.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateModel {
    static final String DEFAULT_INITIAL_STATE = "OFFLINE";
    protected boolean _cancelled;
    Logger logger = LoggerFactory.getLogger(StateModel.class);
    protected String _currentState = "OFFLINE";

    public String getCurrentState() {
        return this._currentState;
    }

    public void defaultTransitionHandler() {
        this.logger.error("Default default handler. The idea is to invoke this if no transition method is found. Yet to be implemented");
    }

    public boolean updateState(String newState) {
        this._currentState = newState;
        return true;
    }

    public void rollbackOnError(Message message, NotificationContext context, StateTransitionError error) {
        this.logger.error("Default rollback method invoked on error. Error Code: " + (Object)((Object)error.getCode()));
    }

    public void syncState() {
        this.logger.warn("Default syncState method invoked without any operation.");
    }

    public void reset() {
        this.logger.warn("Default reset method invoked. Either because the process longer own this resource or session timedout");
    }

    @Transition(to="DROPPED", from="ERROR")
    public void onBecomeDroppedFromError(Message message, NotificationContext context) throws Exception {
        this.logger.info("Default ERROR->DROPPED transition invoked.");
    }

    public void cancel() {
        this._cancelled = true;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }
}

