/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class LeaderStandbyStateModelFactory
extends StateModelFactory<StateModel> {
    int _delay;
    String _instanceName = "";

    public LeaderStandbyStateModelFactory(int delay) {
        this._delay = delay;
    }

    public LeaderStandbyStateModelFactory(String instanceName) {
        this._instanceName = instanceName;
        this._delay = 10;
    }

    public LeaderStandbyStateModelFactory(String instanceName, int delay) {
        this._instanceName = instanceName;
        this._delay = delay;
    }

    public LeaderStandbyStateModelFactory() {
        this(10);
    }

    public void setInstanceName(String instanceName) {
        this._instanceName = instanceName;
    }

    @Override
    public StateModel createNewStateModel(String resourceName, String partitionName) {
        LeaderStandbyStateModel stateModel = new LeaderStandbyStateModel();
        stateModel.setDelay(this._delay);
        stateModel.setInstanceName(this._instanceName);
        stateModel.setPartitionName(partitionName);
        return stateModel;
    }

    public static class LeaderStandbyStateModel
    extends StateModel {
        int _transDelay = 0;
        String partitionName;
        String _instanceName = "";

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public void setInstanceName(String instanceName) {
            this._instanceName = instanceName;
        }

        public void setDelay(int delay) {
            this._transDelay = delay > 0 ? delay : 0;
        }

        public void onBecomeLeaderFromStandby(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeLeaderFromStandby():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        public void onBecomeStandbyFromLeader(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeStandbyFromLeader():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        public void onBecomeStandbyFromOffline(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeStandbyFromOffline():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        public void onBecomeOfflineFromStandby(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeOfflineFromStandby():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeDroppedFromOffline():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        private void sleep() {
            try {
                Thread.sleep(this._transDelay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

