/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class SyncFutureCache {
    private static final long SYNC_FUTURE_INVALIDATION_TIMEOUT_MINS = 2L;
    private final Cache<Thread, SyncFuture> syncFutureCache;

    public SyncFutureCache(Configuration conf) {
        int handlerCount = conf.getInt("hbase.regionserver.handler.count", 30);
        this.syncFutureCache = CacheBuilder.newBuilder().initialCapacity(handlerCount).expireAfterWrite(2L, TimeUnit.MINUTES).build();
    }

    public SyncFuture getIfPresentOrNew() {
        SyncFuture future = (SyncFuture)this.syncFutureCache.asMap().remove(Thread.currentThread());
        return future == null ? new SyncFuture() : future;
    }

    public void offer(SyncFuture syncFuture) {
        this.syncFutureCache.asMap().put(syncFuture.getThread(), syncFuture);
    }

    public void clear() {
        if (this.syncFutureCache != null) {
            this.syncFutureCache.invalidateAll();
        }
    }
}

