/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class CopyTableTestBase {
    protected static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    protected static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    protected static final String FAMILY_A_STRING = "a";
    protected static final String FAMILY_B_STRING = "b";
    protected static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    protected static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    protected static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    @Rule
    public TestName name = new TestName();

    protected abstract Table createSourceTable(TableDescriptor var1) throws Exception;

    protected abstract Table createTargetTable(TableDescriptor var1) throws Exception;

    protected abstract void dropSourceTable(TableName var1) throws Exception;

    protected abstract void dropTargetTable(TableName var1) throws Exception;

    protected abstract String[] getPeerClusterOptions() throws Exception;

    protected final void loadData(Table t, byte[] family, byte[] column) throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put p = new Put(row);
            p.addColumn(family, column, row);
            t.put(p);
        }
    }

    protected final void verifyRows(Table t, byte[] family, byte[] column) throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Get g = new Get(row).addFamily(family);
            Result r = t.get(g);
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            Cell cell = r.rawCells()[0];
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)cell, (byte[])column));
            Assert.assertEquals((long)Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])row, (int)0, (int)row.length), (long)0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doCopyTableTest(Configuration conf, boolean bulkload) throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] family = Bytes.toBytes((String)"family");
        byte[] column = Bytes.toBytes((String)"c1");
        TableDescriptor desc1 = TableDescriptorBuilder.newBuilder((TableName)tableName1).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        TableDescriptor desc2 = TableDescriptorBuilder.newBuilder((TableName)tableName2).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        try (Table t1 = this.createSourceTable(desc1);
             Table t2 = this.createTargetTable(desc2);){
            this.loadData(t1, family, column);
            Object[] peerClusterOptions = this.getPeerClusterOptions();
            if (bulkload) {
                Assert.assertTrue((boolean)this.runCopy(conf, (String[])ArrayUtils.addAll((Object[])peerClusterOptions, (Object[])new String[]{"--new.name=" + tableName2.getNameAsString(), "--bulkload", tableName1.getNameAsString()})));
            } else {
                Assert.assertTrue((boolean)this.runCopy(conf, (String[])ArrayUtils.addAll((Object[])peerClusterOptions, (Object[])new String[]{"--new.name=" + tableName2.getNameAsString(), tableName1.getNameAsString()})));
            }
            this.verifyRows(t2, family, column);
        }
        finally {
            this.dropSourceTable(tableName1);
            this.dropTargetTable(tableName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doCopyTableTestWithMob(Configuration conf, boolean bulkload) throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] family = Bytes.toBytes((String)"mob");
        byte[] column = Bytes.toBytes((String)"c1");
        ColumnFamilyDescriptorBuilder cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])family);
        cfd.setMobEnabled(true);
        cfd.setMobThreshold(5L);
        TableDescriptor desc1 = TableDescriptorBuilder.newBuilder((TableName)tableName1).setColumnFamily(cfd.build()).build();
        TableDescriptor desc2 = TableDescriptorBuilder.newBuilder((TableName)tableName2).setColumnFamily(cfd.build()).build();
        try (Table t1 = this.createSourceTable(desc1);
             Table t2 = this.createTargetTable(desc2);){
            for (int i = 0; i < 10; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(family, column, column);
                t1.put(p);
            }
            Object[] peerClusterOptions = this.getPeerClusterOptions();
            if (bulkload) {
                Assert.assertTrue((boolean)this.runCopy(conf, (String[])ArrayUtils.addAll((Object[])peerClusterOptions, (Object[])new String[]{"--new.name=" + tableName2.getNameAsString(), "--bulkload", tableName1.getNameAsString()})));
            } else {
                Assert.assertTrue((boolean)this.runCopy(conf, (String[])ArrayUtils.addAll((Object[])peerClusterOptions, (Object[])new String[]{"--new.name=" + tableName2.getNameAsString(), tableName1.getNameAsString()})));
            }
            for (int i = 0; i < 10; ++i) {
                Get g = new Get(Bytes.toBytes((String)("row" + i)));
                Result r = t2.get(g);
                Assert.assertEquals((long)1L, (long)r.size());
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])column));
                Assert.assertEquals((String)"compare row values between two tables", (Object)t1.getDescriptor().getValue("row" + i), (Object)t2.getDescriptor().getValue("row" + i));
            }
            Assert.assertEquals((String)"compare count of mob rows after table copy", (long)MobTestUtil.countMobRows((Table)t1), (long)MobTestUtil.countMobRows((Table)t2));
            Assert.assertEquals((String)"compare count of mob row values between two tables", (long)t1.getDescriptor().getValues().size(), (long)t2.getDescriptor().getValues().size());
            Assert.assertTrue((String)"The mob row count is 0 but should be > 0", (MobTestUtil.countMobRows((Table)t2) > 0 ? 1 : 0) != 0);
        }
        finally {
            this.dropSourceTable(tableName1);
            this.dropTargetTable(tableName2);
        }
    }

    protected final boolean runCopy(Configuration conf, String[] args) throws Exception {
        int status = ToolRunner.run((Configuration)conf, (Tool)new CopyTable(), (String[])args);
        return status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void testStartStopRow(Configuration conf) throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] family = Bytes.toBytes((String)"family");
        byte[] column = Bytes.toBytes((String)"c1");
        byte[] row0 = Bytes.toBytesBinary((String)"\\x01row0");
        byte[] row1 = Bytes.toBytesBinary((String)"\\x01row1");
        byte[] row2 = Bytes.toBytesBinary((String)"\\x01row2");
        TableDescriptor desc1 = TableDescriptorBuilder.newBuilder((TableName)tableName1).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        TableDescriptor desc2 = TableDescriptorBuilder.newBuilder((TableName)tableName2).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        try (Table t1 = this.createSourceTable(desc1);
             Table t2 = this.createTargetTable(desc2);){
            Put p = new Put(row0);
            p.addColumn(family, column, column);
            t1.put(p);
            p = new Put(row1);
            p.addColumn(family, column, column);
            t1.put(p);
            p = new Put(row2);
            p.addColumn(family, column, column);
            t1.put(p);
            Object[] peerClusterOptions = this.getPeerClusterOptions();
            Assert.assertTrue((boolean)this.runCopy(conf, (String[])ArrayUtils.addAll((Object[])peerClusterOptions, (Object[])new String[]{"--new.name=" + tableName2, "--startrow=\\x01row1", "--stoprow=\\x01row2", tableName1.getNameAsString()})));
            Get g = new Get(row1);
            Result r = t2.get(g);
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])column));
            g = new Get(row0);
            r = t2.get(g);
            Assert.assertEquals((long)0L, (long)r.size());
            g = new Get(row2);
            r = t2.get(g);
            Assert.assertEquals((long)0L, (long)r.size());
        }
        finally {
            this.dropSourceTable(tableName1);
            this.dropTargetTable(tableName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void testRenameFamily(Configuration conf) throws Exception {
        TableName sourceTable = TableName.valueOf((String)(this.name.getMethodName() + "-source"));
        TableName targetTable = TableName.valueOf((String)(this.name.getMethodName() + "-target"));
        TableDescriptor desc1 = TableDescriptorBuilder.newBuilder((TableName)sourceTable).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_A)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_B)).build();
        TableDescriptor desc2 = TableDescriptorBuilder.newBuilder((TableName)targetTable).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_A)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_B)).build();
        try (Table t = this.createSourceTable(desc1);
             Table t2 = this.createTargetTable(desc2);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data23"));
            t.put(p);
            long currentTime = EnvironmentEdgeManager.currentTime();
            String[] args = (String[])ArrayUtils.addAll((Object[])this.getPeerClusterOptions(), (Object[])new String[]{"--new.name=" + targetTable, "--families=a:b", "--all.cells", "--starttime=" + (currentTime - 100000L), "--endtime=" + (currentTime + 100000L), "--versions=1", sourceTable.getNameAsString()});
            Assert.assertNull((Object)t2.get(new Get(ROW1)).getRow());
            Assert.assertTrue((boolean)this.runCopy(conf, args));
            Assert.assertNotNull((Object)t2.get(new Get(ROW1)).getRow());
            Result res = t2.get(new Get(ROW1));
            byte[] b1 = res.getValue(FAMILY_B, QUALIFIER);
            Assert.assertEquals((Object)"Data13", (Object)Bytes.toString((byte[])b1));
            Assert.assertNotNull((Object)t2.get(new Get(ROW2)).getRow());
            res = t2.get(new Get(ROW2));
            b1 = res.getValue(FAMILY_A, QUALIFIER);
            Assert.assertNull((Object)b1);
        }
        finally {
            this.dropSourceTable(sourceTable);
            this.dropTargetTable(targetTable);
        }
    }
}

