/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotCleanerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotCleanerChore.class);
    private static final String SNAPSHOT_CLEANER_CHORE_NAME = "SnapshotCleaner";
    private static final String SNAPSHOT_CLEANER_INTERVAL = "hbase.master.cleaner.snapshot.interval";
    private static final int SNAPSHOT_CLEANER_DEFAULT_INTERVAL = 1800000;
    private static final String DELETE_SNAPSHOT_EVENT = "Eligible Snapshot for cleanup due to expired TTL.";
    private final SnapshotManager snapshotManager;

    public SnapshotCleanerChore(Stoppable stopper, Configuration configuration, SnapshotManager snapshotManager) {
        super(SNAPSHOT_CLEANER_CHORE_NAME, stopper, configuration.getInt(SNAPSHOT_CLEANER_INTERVAL, 1800000));
        this.snapshotManager = snapshotManager;
    }

    @Override
    protected void chore() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Snapshot Cleaner Chore is starting up...");
        }
        try {
            List<SnapshotProtos.SnapshotDescription> completedSnapshotsList = this.snapshotManager.getCompletedSnapshots();
            for (SnapshotProtos.SnapshotDescription snapshotDescription : completedSnapshotsList) {
                long currentTime;
                long snapshotCreatedTime = snapshotDescription.getCreationTime();
                long snapshotTtl = snapshotDescription.getTtl();
                if (!SnapshotDescriptionUtils.isExpiredSnapshot(snapshotTtl, snapshotCreatedTime, currentTime = EnvironmentEdgeManager.currentTime())) continue;
                LOG.info("Event: {} Name: {}, CreatedTime: {}, TTL: {}, currentTime: {}", new Object[]{DELETE_SNAPSHOT_EVENT, snapshotDescription.getName(), snapshotCreatedTime, snapshotTtl, currentTime});
                this.deleteExpiredSnapshot(snapshotDescription);
            }
        }
        catch (IOException e) {
            LOG.error("Error while cleaning up Snapshots...", (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Snapshot Cleaner Chore is closing...");
        }
    }

    private void deleteExpiredSnapshot(SnapshotProtos.SnapshotDescription snapshotDescription) {
        try {
            this.snapshotManager.deleteSnapshot(snapshotDescription);
        }
        catch (Exception e) {
            LOG.error("Error while deleting Snapshot: {}", (Object)snapshotDescription.getName(), (Object)e);
        }
    }
}

