/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.CostFromRegionLoadFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CostFromRegionLoadAsRateFunction
extends CostFromRegionLoadFunction {
    CostFromRegionLoadAsRateFunction() {
    }

    @Override
    protected double getRegionLoadCost(Collection<BalancerRegionLoad> regionLoadList) {
        Iterator<BalancerRegionLoad> iter = regionLoadList.iterator();
        if (!iter.hasNext()) {
            return 0.0;
        }
        double previous = this.getCostFromRl(iter.next());
        if (!iter.hasNext()) {
            return 0.0;
        }
        double cost = 0.0;
        do {
            double current;
            cost += (current = this.getCostFromRl(iter.next())) >= previous ? current - previous : current;
            previous = current;
        } while (iter.hasNext());
        return Math.max(0.0, cost / (double)(regionLoadList.size() - 1));
    }
}

