/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.TestReplicationStatus;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationStatusSink
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationStatusSink.class);

    @Test
    public void testReplicationStatusSink() throws Exception {
        try (Admin admin = UTIL2.getConnection().getAdmin();){
            ServerName server = UTIL2.getHBaseCluster().getRegionServer(0).getServerName();
            ReplicationLoadSink loadSink = this.getLatestSinkMetric(admin, server);
            Assert.assertEquals((long)loadSink.getTimestampStarted(), (long)loadSink.getTimestampsOfLastAppliedOp());
            TestReplicationStatus.insertRowsOnSource();
            long wait = Waiter.waitFor((Configuration)UTIL2.getConfiguration(), (long)10000L, () -> {
                ReplicationLoadSink loadSink1 = this.getLatestSinkMetric(admin, server);
                return loadSink1.getTimestampsOfLastAppliedOp() > loadSink1.getTimestampStarted();
            });
            Assert.assertNotEquals((long)-1L, (long)wait);
        }
    }

    private ReplicationLoadSink getLatestSinkMetric(Admin admin, ServerName server) throws IOException {
        ClusterMetrics metrics = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        ServerMetrics sm = (ServerMetrics)metrics.getLiveServerMetrics().get(server);
        return sm.getReplicationLoadSink();
    }
}

