/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.PING;
import org.jgroups.util.Buffer;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public class MPING
extends PING
implements Runnable {
    private static final boolean can_bind_to_mcast_addr = Util.checkForLinux() && !Util.checkForAndroid() || Util.checkForSolaris() || Util.checkForHp();
    @LocalAddress
    @Property(description="Bind address for multicast socket. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"})
    InetAddress bind_addr = null;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str = null;
    @Property(description="Time to live for discovery packets. Default is 8", systemProperty={"jgroups.mping.ip_ttl"})
    int ip_ttl = 8;
    @Property(description="Multicast address to be used for discovery", name="mcast_addr", systemProperty={"jgroups.mping.mcast_addr"}, defaultValueIPv4="230.5.6.7", defaultValueIPv6="ff0e::5:6:7")
    InetAddress mcast_addr = null;
    @Property(description="Multicast port for discovery packets. Default is 7555", systemProperty={"jgroups.mping.mcast_port"})
    int mcast_port = 7555;
    @Property(description="If true, the transport should use all available interfaces to receive multicast messages. Default is false")
    boolean receive_on_all_interfaces = false;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="List of interfaces to receive multicasts on")
    List<NetworkInterface> receive_interfaces = null;
    @Property(description="Whether send messages are sent on all interfaces. Default is false")
    boolean send_on_all_interfaces = false;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="List of interfaces to send multicasts on")
    List<NetworkInterface> send_interfaces = null;
    private MulticastSocket mcast_sock = null;
    private MulticastSocket[] mcast_send_sockets = null;
    private volatile Thread receiver = null;

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public void setBindAddr(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public List<NetworkInterface> getSendInterfaces() {
        return this.send_interfaces;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public boolean isSendOnAllInterfaces() {
        return this.send_on_all_interfaces;
    }

    public int getTTL() {
        return this.ip_ttl;
    }

    public void setTTL(int ip_ttl) {
        this.ip_ttl = ip_ttl;
    }

    public InetAddress getMcastAddr() {
        return this.mcast_addr;
    }

    public void setMcastAddr(InetAddress mcast_addr) {
        this.mcast_addr = mcast_addr;
    }

    public void setMulticastAddress(String addr) throws UnknownHostException {
        this.mcast_addr = InetAddress.getByName(addr);
    }

    public int getMcastPort() {
        return this.mcast_port;
    }

    public void setMcastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 56) {
            if (this.bind_addr == null) {
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
            return this.up_prot.up(evt);
        }
        return super.up(evt);
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.log.isDebugEnabled()) {
            this.log.debug("bind_addr=" + this.bind_addr + " mcast_addr=" + this.mcast_addr + ", mcast_port=" + this.mcast_port);
        }
    }

    @Override
    public void start() throws Exception {
        List<NetworkInterface> interfaces;
        this.mcast_sock = can_bind_to_mcast_addr ? Util.createMulticastSocket(this.getSocketFactory(), "jgroups.mping.mcast_sock", this.mcast_addr, this.mcast_port, this.log) : this.getSocketFactory().createMulticastSocket("jgroups.mping.mcast_sock", this.mcast_port);
        this.mcast_sock.setTimeToLive(this.ip_ttl);
        if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
            interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.mcast_sock, this.mcast_addr);
        } else {
            if (this.bind_addr != null) {
                this.mcast_sock.setInterface(this.bind_addr);
            }
            this.mcast_sock.joinGroup(this.mcast_addr);
        }
        if (this.send_on_all_interfaces || this.send_interfaces != null && !this.send_interfaces.isEmpty()) {
            interfaces = this.send_interfaces != null ? this.send_interfaces : Util.getAllAvailableInterfaces();
            this.mcast_send_sockets = new MulticastSocket[interfaces.size()];
            int index = 0;
            for (NetworkInterface intf : interfaces) {
                this.mcast_send_sockets[index] = new MulticastSocket();
                this.mcast_send_sockets[index].setNetworkInterface(intf);
                this.mcast_send_sockets[index].setTimeToLive(this.ip_ttl);
                ++index;
            }
        }
        this.startReceiver();
        super.start();
    }

    private void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcast_addr) throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcast_addr, this.mcast_port);
        block0: for (NetworkInterface i : interfaces) {
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if ((Util.getIpStackType() != StackType.IPv4 || !(addr instanceof Inet4Address)) && (Util.getIpStackType() != StackType.IPv6 || !(addr instanceof Inet6Address))) continue;
                s.joinGroup(tmp_mcast_addr, i);
                if (!this.log.isTraceEnabled()) continue block0;
                this.log.trace("joined " + tmp_mcast_addr + " on " + i.getName() + " (" + addr + ")");
                continue block0;
            }
        }
    }

    private void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            this.receiver = new Thread((Runnable)this, "MPING");
            this.receiver.setDaemon(true);
            this.receiver.start();
            if (this.log.isTraceEnabled()) {
                this.log.trace("receiver thread started");
            }
        }
    }

    @Override
    public void stop() {
        this.receiver = null;
        Util.close((Closeable)this.mcast_sock);
        this.mcast_sock = null;
        super.stop();
    }

    @Override
    protected void sendMcastDiscoveryRequest(Message msg) {
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(128);
            msg.writeTo(out);
            Buffer buf = out.getBuffer();
            DatagramPacket packet = new DatagramPacket(buf.getBuf(), buf.getOffset(), buf.getLength(), this.mcast_addr, this.mcast_port);
            if (this.mcast_send_sockets != null) {
                for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                    MulticastSocket s = this.mcast_send_sockets[i];
                    try {
                        s.send(packet);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error(Util.getMessage("FailedSendingPacketOnSocket"), s);
                    }
                }
            } else if (this.mcast_sock != null) {
                this.mcast_sock.send(packet);
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSendingDiscoveryRequest"), ex);
        }
    }

    @Override
    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_sock != null && this.receiver != null && Thread.currentThread().equals(this.receiver)) {
            packet.setData(receive_buf, 0, receive_buf.length);
            try {
                this.mcast_sock.receive(packet);
                ByteArrayDataInputStream inp = new ByteArrayDataInputStream(packet.getData(), packet.getOffset(), packet.getLength());
                Message msg = new Message();
                msg.readFrom(inp);
                this.up(new Event(1, msg));
            }
            catch (SocketException socketEx) {
                break;
            }
            catch (Throwable ex) {
                this.log.error(Util.getMessage("FailedReceivingPacketFrom"), packet.getSocketAddress(), ex);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiver thread terminated");
        }
    }
}

