/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.jgroups.Address;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.Client;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.NioClient;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.blocks.cs.TcpClient;
import org.jgroups.util.Util;

public class PubClient
extends ReceiverAdapter
implements ConnectionListener {
    protected BaseServer client;
    protected final String name;
    protected volatile boolean running = true;
    protected InputStream in;

    public PubClient(String name) {
        this.name = name;
    }

    @Override
    public void receive(Address sender, ByteBuffer buf) {
        String msg = new String(buf.array(), buf.arrayOffset(), buf.limit());
        System.out.printf("-- %s\n", msg);
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        String msg = new String(buf, offset, length);
        System.out.printf("-- %s\n", msg);
    }

    @Override
    public void connectionClosed(Connection conn) {
        this.client.stop();
        this.running = false;
        Util.close((Closeable)this.in);
        System.out.printf("connection to %s closed", conn.peerAddress());
    }

    @Override
    public void connectionEstablished(Connection conn) {
    }

    protected void start(InetAddress srv_addr, int srv_port, boolean nio) throws Exception {
        this.client = nio ? new NioClient(InetAddress.getLocalHost(), 0, srv_addr, srv_port) : new TcpClient(InetAddress.getLocalHost(), 0, srv_addr, srv_port);
        this.client.receiver(this);
        this.client.addConnectionListener(this);
        this.client.start();
        byte[] buf = String.format("%s joined\n", this.name).getBytes();
        ((Client)((Object)this.client)).send(buf, 0, buf.length);
        this.eventLoop();
        this.client.stop();
    }

    protected void eventLoop() {
        this.in = new BufferedInputStream(System.in);
        while (this.running) {
            try {
                System.out.print("> ");
                System.out.flush();
                String line = Util.readLine(this.in);
                if (line == null || line.startsWith("quit") || line.startsWith("exit")) break;
                byte[] buf = String.format("%s: %s\n", this.name, line).getBytes();
                ((Client)((Object)this.client)).send(buf, 0, buf.length);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        InetAddress server_addr = InetAddress.getLocalHost();
        int server_port = 7500;
        String name = null;
        boolean nio = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-addr")) {
                server_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                server_port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-nio")) {
                nio = Boolean.parseBoolean(args[++i]);
                continue;
            }
            PubClient.help();
            return;
        }
        if (name == null) {
            throw new IllegalStateException("name needs to be defined");
        }
        PubClient client = new PubClient(name);
        client.start(server_addr, server_port, nio);
    }

    protected static void help() {
        System.out.println("PubClient -name name [-addr <server address>] [-port <server port>] [-nio true|false]");
    }
}

