/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.internal.WanCopyRegionFunctionService;
import org.apache.geode.cache.wan.internal.WanCopyRegionFunctionServiceAlreadyRunningException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.InternalGatewaySender;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.WanCopyRegionFunctionDelegate;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class WanCopyRegionFunction
extends CliFunction<Object[]>
implements Declarable {
    private static final long serialVersionUID = 1L;
    public static final String ID = WanCopyRegionFunction.class.getName();
    private final WanCopyRegionFunctionServiceProvider serviceProvider;
    private static final Logger logger = LogService.getLogger();
    public static final String WAN_COPY_REGION__MSG__REGION__NOT__FOUND = "Region {0} not found";
    public static final String WAN_COPY_REGION__MSG__REGION__NOT__USING_SENDER = "Region {0} is not configured to use sender {1}";
    public static final String WAN_COPY_REGION__MSG__SENDER__NOT__FOUND = "Sender {0} not found";
    public static final String WAN_COPY_REGION__MSG__SENDER__SERIAL__AND__NOT__PRIMARY = "Sender {0} is serial and not primary. 0 entries copied.";
    public static final String WAN_COPY_REGION__MSG__SENDER__NOT__RUNNING = "Sender {0} is not running";
    public static final String WAN_COPY_REGION__MSG__EXECUTION__CANCELED = "Execution canceled";
    public static final String WAN_COPY_REGION__MSG__EXECUTIONS__CANCELED = "Executions canceled: {0}";
    public static final String WAN_COPY_REGION__MSG__EXECUTION__FAILED = "Execution failed. Error: {0}";
    public static final String WAN_COPY_REGION__MSG__CANCELED__BEFORE__HAVING__COPIED = "Operation canceled before having copied all entries";
    public static final String WAN_COPY_REGION__MSG__NO__RUNNING__COMMAND = "No running command to be canceled for region {0} and sender {1}";
    public static final String WAN_COPY_REGION__MSG__ALREADY__RUNNING__COMMAND = "There is already a command running for region {0} and sender {1}";

    public WanCopyRegionFunction() {
        this(new WanCopyRegionFunctionServiceProviderImpl());
    }

    @VisibleForTesting
    WanCopyRegionFunction(WanCopyRegionFunctionServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) {
        Object[] args = context.getArguments();
        if (args.length < 5) {
            throw new IllegalStateException("Arguments length does not match required length.");
        }
        String regionName = (String)args[0];
        String senderId = (String)args[1];
        boolean isCancel = (Boolean)args[2];
        long maxRate = (Long)args[3];
        int batchSize = (Integer)args[4];
        if (regionName.startsWith("/")) {
            regionName = regionName.substring(1);
        }
        if (regionName.equals("*") && senderId.equals("*") && isCancel) {
            return this.cancelAllWanCopyRegion(context);
        }
        if (isCancel) {
            return this.cancelWanCopyRegion(context, regionName, senderId);
        }
        Cache cache = context.getCache();
        Region region = cache.getRegion(regionName);
        if (region == null) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__REGION__NOT__FOUND, (Object)regionName));
        }
        GatewaySender sender = cache.getGatewaySender(senderId);
        if (sender == null) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__SENDER__NOT__FOUND, (Object)senderId));
        }
        if (!region.getAttributes().getGatewaySenderIds().contains(sender.getId())) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__REGION__NOT__USING_SENDER, regionName, senderId));
        }
        if (!sender.isRunning()) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__SENDER__NOT__RUNNING, (Object)senderId));
        }
        if (!sender.isParallel() && !((InternalGatewaySender)sender).isPrimary()) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, CliStrings.format(WAN_COPY_REGION__MSG__SENDER__SERIAL__AND__NOT__PRIMARY, (Object)senderId));
        }
        return this.executeFunctionInService(context, region, sender, maxRate, batchSize);
    }

    private CliFunctionResult executeFunctionInService(FunctionContext<Object[]> context, Region<?, ?> region, GatewaySender sender, long maxRate, int batchSize) {
        try {
            return this.serviceProvider.get((InternalCache)context.getCache()).execute(() -> new WanCopyRegionFunctionDelegate().wanCopyRegion((InternalCache)context.getCache(), context.getMemberName(), region, sender, maxRate, batchSize), region.getName(), sender.getId());
        }
        catch (InterruptedException | CancellationException e) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, WAN_COPY_REGION__MSG__CANCELED__BEFORE__HAVING__COPIED);
        }
        catch (ExecutionException e) {
            logger.error("Exception occurred attempting to wan-copy region", (Throwable)e);
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__EXECUTION__FAILED, (Object)e.getMessage()));
        }
        catch (WanCopyRegionFunctionServiceAlreadyRunningException e) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__ALREADY__RUNNING__COMMAND, region.getName(), sender.getId()));
        }
    }

    private CliFunctionResult cancelWanCopyRegion(FunctionContext<Object[]> context, String regionName, String senderId) {
        boolean canceled = this.serviceProvider.get((InternalCache)context.getCache()).cancel(regionName, senderId);
        if (!canceled) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format(WAN_COPY_REGION__MSG__NO__RUNNING__COMMAND, regionName, senderId));
        }
        return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, WAN_COPY_REGION__MSG__EXECUTION__CANCELED);
    }

    private CliFunctionResult cancelAllWanCopyRegion(FunctionContext<Object[]> context) {
        String executionsString = this.serviceProvider.get((InternalCache)context.getCache()).cancelAll();
        return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, CliStrings.format(WAN_COPY_REGION__MSG__EXECUTIONS__CANCELED, (Object)executionsString));
    }

    static class WanCopyRegionFunctionServiceProviderImpl
    implements WanCopyRegionFunctionServiceProvider {
        WanCopyRegionFunctionServiceProviderImpl() {
        }

        @Override
        public WanCopyRegionFunctionService get(InternalCache cache) {
            return cache.getService(WanCopyRegionFunctionService.class);
        }
    }

    @FunctionalInterface
    static interface WanCopyRegionFunctionServiceProvider
    extends Serializable {
        public WanCopyRegionFunctionService get(InternalCache var1);
    }
}

