/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.internal.cache.InternalCache;

@Experimental
public abstract class AbstractJdbcCallback
implements CacheCallback {
    private volatile SqlHandler sqlHandler;
    protected InternalCache cache;

    protected AbstractJdbcCallback() {
    }

    protected AbstractJdbcCallback(SqlHandler sqlHandler, InternalCache cache) {
        this.sqlHandler = sqlHandler;
        this.cache = cache;
    }

    protected SqlHandler getSqlHandler() {
        return this.sqlHandler;
    }

    protected void checkInitialized(Region<?, ?> region) {
        if (this.sqlHandler == null) {
            this.initialize(region);
        }
    }

    protected boolean eventCanBeIgnored(Operation operation) {
        return operation.isLoad();
    }

    private synchronized void initialize(Region<?, ?> region) {
        if (this.sqlHandler == null) {
            this.cache = (InternalCache)region.getRegionService();
            JdbcConnectorService service = (JdbcConnectorService)this.cache.getService(JdbcConnectorService.class);
            TableMetaDataManager tableMetaDataManager = new TableMetaDataManager();
            this.sqlHandler = this.createSqlHandler(this.cache, region.getName(), tableMetaDataManager, service);
        }
    }

    SqlHandler createSqlHandler(InternalCache cache, String regionName, TableMetaDataManager tableMetaDataManager, JdbcConnectorService service) {
        return new SqlHandler(cache, regionName, tableMetaDataManager, service);
    }
}

