/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeap;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryOffHeapUUIDKey;

public abstract class VersionedStatsRegionEntryOffHeap
extends VersionedStatsRegionEntry
implements OffHeapRegionEntry {
    @Immutable
    private static final VersionedStatsRegionEntryOffHeapFactory factory = new VersionedStatsRegionEntryOffHeapFactory();

    public VersionedStatsRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsRegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsRegionEntryHeap.getEntryFactory();
        }
    }
}

