/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.admin.remote.RegionAdminMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DestroyEntryMessage
extends RegionAdminMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private ExpirationAction action;

    public static DestroyEntryMessage create(Object key, ExpirationAction action) {
        DestroyEntryMessage m = new DestroyEntryMessage();
        m.action = action;
        m.key = key;
        return m;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                if (this.action == ExpirationAction.LOCAL_DESTROY) {
                    r.localDestroy(this.key);
                } else if (this.action == ExpirationAction.DESTROY) {
                    r.destroy(this.key);
                } else if (this.action == ExpirationAction.INVALIDATE) {
                    r.invalidate(this.key);
                } else if (this.action == ExpirationAction.LOCAL_INVALIDATE) {
                    r.localInvalidate(this.key);
                }
            }
            catch (Exception e) {
                logger.warn("Failed attempt to destroy or invalidate entry {} {} from console at {}", new Object[]{r.getFullPath(), this.key, this.getSender()});
            }
        }
    }

    public int getDSFID() {
        return 1019;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.action, out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.action = (ExpirationAction)DataSerializer.readObject(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return String.format("DestroyEntryMessage from %s", this.getSender());
    }
}

