/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.Statistic;
import org.apache.geode.admin.SystemMemberCacheServer;
import org.apache.geode.admin.SystemMemberRegion;
import org.apache.geode.admin.internal.SystemMemberBridgeServerImpl;
import org.apache.geode.admin.internal.SystemMemberCacheImpl;
import org.apache.geode.admin.jmx.internal.DynamicManagedBean;
import org.apache.geode.admin.jmx.internal.MBeanUtils;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.admin.jmx.internal.StatisticAttributeInfo;
import org.apache.geode.admin.jmx.internal.SystemMemberBridgeServerJmxImpl;
import org.apache.geode.admin.jmx.internal.SystemMemberRegionJmxImpl;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.logging.log4j.Level;

@Deprecated
public class SystemMemberCacheJmxImpl
extends SystemMemberCacheImpl
implements ManagedResource {
    private ObjectName objectName;
    private final Map<String, SystemMemberRegionJmxImpl> managedRegionResourcesMap = new HashMap<String, SystemMemberRegionJmxImpl>();
    private final Map<Number, SystemMemberBridgeServerJmxImpl> managedCacheServerResourcesMap = new HashMap<Number, SystemMemberBridgeServerJmxImpl>();
    private String mbeanName;
    private ModelMBean modelMBean;

    public SystemMemberCacheJmxImpl(GemFireVM vm) throws AdminException {
        super(vm);
        this.initializeMBean();
    }

    private void initializeMBean() throws AdminException {
        this.mbeanName = "GemFire.Cache:name=" + MBeanUtils.makeCompliantMBeanNameProperty(this.getName()) + ",id=" + this.getId() + ",owner=" + MBeanUtils.makeCompliantMBeanNameProperty(this.vm.getId().toString()) + ",type=Cache";
        this.objectName = MBeanUtils.createMBean(this, this.addDynamicAttributes(MBeanUtils.lookupManagedBean(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SystemMemberRegion createSystemMemberRegion(Region r) throws AdminException {
        SystemMemberRegionJmxImpl managedSystemMemberRegion = null;
        boolean needsRefresh = false;
        Map<String, SystemMemberRegionJmxImpl> map = this.managedRegionResourcesMap;
        synchronized (map) {
            SystemMemberRegionJmxImpl managedResource = this.managedRegionResourcesMap.get(r.getFullPath());
            if (managedResource != null) {
                managedSystemMemberRegion = managedResource;
            } else {
                managedSystemMemberRegion = new SystemMemberRegionJmxImpl(this, r);
                this.managedRegionResourcesMap.put(r.getFullPath(), managedSystemMemberRegion);
                needsRefresh = true;
            }
        }
        if (needsRefresh) {
            managedSystemMemberRegion.refresh();
        }
        return managedSystemMemberRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SystemMemberBridgeServerImpl createSystemMemberBridgeServer(AdminBridgeServer bridge) throws AdminException {
        SystemMemberBridgeServerJmxImpl managedSystemMemberBridgeServer = null;
        Map<Number, SystemMemberBridgeServerJmxImpl> map = this.managedCacheServerResourcesMap;
        synchronized (map) {
            SystemMemberBridgeServerJmxImpl managedCacheServerResource = this.managedCacheServerResourcesMap.get(bridge.getId());
            if (managedCacheServerResource != null) {
                managedSystemMemberBridgeServer = managedCacheServerResource;
            } else {
                managedSystemMemberBridgeServer = new SystemMemberBridgeServerJmxImpl(this, bridge);
                this.managedCacheServerResourcesMap.put(bridge.getId(), managedSystemMemberBridgeServer);
            }
        }
        return managedSystemMemberBridgeServer;
    }

    ManagedBean addDynamicAttributes(ManagedBean managed) throws AdminException {
        if (managed == null) {
            throw new IllegalArgumentException("ManagedBean is null");
        }
        this.refresh();
        DynamicManagedBean newManagedBean = new DynamicManagedBean(managed);
        for (Statistic statistic : this.statistics) {
            StatisticAttributeInfo attrInfo = new StatisticAttributeInfo();
            attrInfo.setName(statistic.getName());
            attrInfo.setDisplayName(statistic.getName());
            attrInfo.setDescription(statistic.getDescription());
            attrInfo.setType("java.lang.Number");
            attrInfo.setIs(false);
            attrInfo.setReadable(true);
            attrInfo.setWriteable(false);
            attrInfo.setStat(statistic);
            newManagedBean.addAttribute(attrInfo);
        }
        return newManagedBean;
    }

    public ObjectName manageRegion(String path) throws AdminException, MalformedObjectNameException {
        try {
            SystemMemberRegionJmxImpl region = null;
            try {
                region = (SystemMemberRegionJmxImpl)this.getRegion(path);
            }
            catch (AdminException e) {
                MBeanUtils.logStackTrace(Level.WARN, e);
                throw e;
            }
            if (region == null) {
                throw new AdminException(String.format("This cache does not contain region %s", path));
            }
            return ObjectName.getInstance(region.getMBeanName());
        }
        catch (RuntimeException e) {
            MBeanUtils.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtils.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    public ObjectName manageCacheServer() throws AdminException, MalformedObjectNameException {
        try {
            SystemMemberBridgeServerJmxImpl bridge = (SystemMemberBridgeServerJmxImpl)this.addCacheServer();
            return ObjectName.getInstance(bridge.getMBeanName());
        }
        catch (AdminException e) {
            MBeanUtils.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (RuntimeException e) {
            MBeanUtils.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtils.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    public ObjectName[] manageCacheServers() throws AdminException, MalformedObjectNameException {
        try {
            SystemMemberCacheServer[] bridges = this.getCacheServers();
            ObjectName[] names = new ObjectName[bridges.length];
            for (int i = 0; i < bridges.length; ++i) {
                SystemMemberBridgeServerJmxImpl bridge = (SystemMemberBridgeServerJmxImpl)bridges[i];
                names[i] = ObjectName.getInstance(bridge.getMBeanName());
            }
            return names;
        }
        catch (AdminException e) {
            MBeanUtils.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (RuntimeException e) {
            MBeanUtils.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtils.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    @Deprecated
    public ObjectName[] manageBridgeServers() throws AdminException, MalformedObjectNameException {
        return this.manageCacheServers();
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.SYSTEM_MEMBER_CACHE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupResource() {
        Collection<ManagedResource> values;
        Map<Object, ManagedResource> map = this.managedRegionResourcesMap;
        synchronized (map) {
            values = this.managedRegionResourcesMap.values();
            for (SystemMemberRegionJmxImpl systemMemberRegionJmxImpl : values) {
                MBeanUtils.unregisterMBean(systemMemberRegionJmxImpl);
            }
            this.managedRegionResourcesMap.clear();
        }
        map = this.managedCacheServerResourcesMap;
        synchronized (map) {
            values = this.managedCacheServerResourcesMap.values();
            for (SystemMemberBridgeServerJmxImpl systemMemberBridgeServerJmxImpl : values) {
                MBeanUtils.unregisterMBean(systemMemberBridgeServerJmxImpl);
            }
            this.managedCacheServerResourcesMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedResource cleanupRegionResources(String regionPath) {
        SystemMemberRegionJmxImpl cleaned = null;
        Map<String, SystemMemberRegionJmxImpl> map = this.managedRegionResourcesMap;
        synchronized (map) {
            Set<Map.Entry<String, SystemMemberRegionJmxImpl>> entries = this.managedRegionResourcesMap.entrySet();
            Iterator<Map.Entry<String, SystemMemberRegionJmxImpl>> it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry<String, SystemMemberRegionJmxImpl> entry = it.next();
                SystemMemberRegionJmxImpl managedResource = entry.getValue();
                ObjectName objName = managedResource.getObjectName();
                String pathProp = objName.getKeyProperty("path");
                if (pathProp == null || !pathProp.equals(regionPath)) continue;
                cleaned = managedResource;
                it.remove();
                break;
            }
        }
        return cleaned;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemMemberCacheJmxImpl)) {
            return false;
        }
        SystemMemberCacheJmxImpl other = (SystemMemberCacheJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

