/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.lang.invoke.MethodHandle;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;

public class PartialByteArrayMessageSink
extends AbstractMessageSink {
    public PartialByteArrayMessageSink(CoreSession session, MethodHandle methodHandle, boolean autoDemand) {
        super(session, methodHandle, autoDemand);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload() || frame.isFin()) {
                byte[] buffer = BufferUtil.toArray(frame.getPayload());
                this.getMethodHandle().invoke(buffer, frame.isFin());
                callback.succeeded();
                this.autoDemand();
            } else {
                callback.succeeded();
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

