// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.AlwaysNotNullable;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.BooleanType;
import org.apache.doris.nereids.types.DateTimeType;
import org.apache.doris.nereids.types.DateTimeV2Type;
import org.apache.doris.nereids.types.DateV2Type;
import org.apache.doris.nereids.types.StringType;
import org.apache.doris.nereids.util.ExpressionUtils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'sequence_count'. This class is generated by GenerateFunction.
 */
public class SequenceCount extends AggregateFunction
        implements ExplicitlyCastableSignature, AlwaysNotNullable, SequenceFunction {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .varArgs(StringType.INSTANCE, DateV2Type.INSTANCE, BooleanType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .varArgs(StringType.INSTANCE, DateTimeType.INSTANCE, BooleanType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .varArgs(StringType.INSTANCE, DateTimeV2Type.SYSTEM_DEFAULT, BooleanType.INSTANCE)
    );

    /**
     * constructor with 3 or more arguments.
     */
    public SequenceCount(Expression arg0, Expression arg1, Expression arg2, Expression... varArgs) {
        super("sequence_count", ExpressionUtils.mergeArguments(arg0, arg1, arg2, varArgs));
    }

    /**
     * constructor with 3 or more arguments.
     */
    public SequenceCount(boolean distinct, Expression arg0, Expression arg1, Expression arg2, Expression... varArgs) {
        super("sequence_count", distinct,
                ExpressionUtils.mergeArguments(arg0, arg1, arg2, varArgs));
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public SequenceCount withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() >= 3);
        return new SequenceCount(distinct, children.get(0), children.get(1), children.get(2),
                children.subList(3, children.size()).toArray(new Expression[0]));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSequenceCount(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
