/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;

public class SourceToXml {
    private int idCounter = 0;
    private String indent = "  ";
    private static final String ID_ATTRIBUTE = "id";
    private static final String REFID_ATTRIBUTE = "refid";
    private static final Map<Character, String> ESCAPE_MAP;

    public String toXml(SourceElement rootElement, boolean createIdAttributes) throws SourceException {
        HashMap<SourceElement, Integer> knownElements = new HashMap<SourceElement, Integer>();
        StringBuilder result = new StringBuilder();
        String currentIndent = "";
        this.outputElement(rootElement, knownElements, result, currentIndent, true, createIdAttributes);
        result.append("\n");
        return result.toString();
    }

    private void outputElement(SourceElement currentElement, Map<SourceElement, Integer> knownElements, StringBuilder result, String currentIndent, boolean identAtStart, boolean automaticIds) throws SourceException {
        boolean hasChildren;
        Integer knownElementId = knownElements.get(currentElement);
        if (knownElementId != null) {
            if (!automaticIds) {
                throw new SourceException("An element with name " + currentElement.getName() + " occurs at least twice in the source graph, but createIdAttributes is false.");
            }
            result.append(currentIndent).append("<").append(currentElement.getName()).append(" ").append(REFID_ATTRIBUTE).append("=\"").append(knownElementId).append("\"/>");
            return;
        }
        Integer currentId = this.getId();
        knownElements.put(currentElement, currentId);
        if (identAtStart) {
            result.append(currentIndent);
        }
        result.append("<").append(currentElement.getName());
        boolean hasTextAttribute = false;
        for (String attributeName : currentElement.getAttributeNames()) {
            if (attributeName == null) {
                hasTextAttribute = true;
                continue;
            }
            result.append(" ").append(attributeName).append("=\"");
            this.appendWithEscaping(currentElement.getAttribute(attributeName).toString(), result);
            result.append("\"");
        }
        if (automaticIds) {
            result.append(" ").append(ID_ATTRIBUTE).append("=\"").append(currentId).append("\"");
        }
        boolean bl = hasChildren = !currentElement.getChildren().isEmpty();
        if (hasChildren || hasTextAttribute) {
            result.append(">");
            if (hasTextAttribute) {
                this.appendWithEscaping(currentElement.getAttribute((String)null).toString(), result);
            }
        } else {
            result.append("/>");
        }
        String childIndent = currentIndent + this.indent;
        SourceElement previousChild = null;
        for (SourceElement child : currentElement.getChildren()) {
            if (!hasTextAttribute) {
                result.append("\n");
            }
            this.outputElement(child, knownElements, result, childIndent, previousChild != null || !hasTextAttribute, automaticIds);
            previousChild = child;
        }
        if (previousChild != null) {
            result.append("\n");
        }
        if (hasChildren || hasTextAttribute) {
            if (hasChildren) {
                result.append(currentIndent);
            }
            result.append("</").append(currentElement.getName()).append(">");
        }
    }

    private synchronized Integer getId() {
        ++this.idCounter;
        return this.idCounter;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        if (indent == null) {
            throw new NullPointerException("indent is null");
        }
        this.indent = indent;
    }

    private void appendWithEscaping(String toAppend, StringBuilder stringBuilder) {
        for (int pos = 0; pos < toAppend.length(); ++pos) {
            char current = toAppend.charAt(pos);
            String escapeSequence = ESCAPE_MAP.get(Character.valueOf(current));
            if (escapeSequence != null) {
                stringBuilder.append(escapeSequence);
                continue;
            }
            stringBuilder.append(current);
        }
    }

    static {
        HashMap<Character, String> escapeMap = new HashMap<Character, String>();
        escapeMap.put(Character.valueOf('&'), "&amp;");
        escapeMap.put(Character.valueOf('>'), "&gt;");
        escapeMap.put(Character.valueOf('<'), "&lt;");
        escapeMap.put(Character.valueOf('\"'), "&quot;");
        escapeMap.put(Character.valueOf('\''), "&apo;");
        ESCAPE_MAP = Collections.unmodifiableMap(escapeMap);
    }
}

