/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.option;

import java.util.Objects;
import org.apache.torque.generator.option.Option;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;

public class OptionImpl
implements Option {
    private final QualifiedName qualifiedName;
    private final Object value;

    public OptionImpl(String namespace, String name, Object value) {
        this.qualifiedName = new QualifiedName(namespace, name);
        this.value = value;
    }

    public OptionImpl(String qualifiedName, Object value) {
        this(new QualifiedName(qualifiedName, Namespace.ROOT_NAMESPACE), value);
    }

    public OptionImpl(QualifiedName qualifiedName, Object value) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("qualifiedName must not be zero");
        }
        this.qualifiedName = qualifiedName;
        this.value = value;
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("(qualifiedName=").append(this.qualifiedName).append(", value=").append(this.value).append(")");
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedName, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OptionImpl other = (OptionImpl)obj;
        if (!Objects.equals(this.qualifiedName, other.qualifiedName)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

