/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.configuration.outlet.OutletConfigurationSaxHandler;
import org.apache.torque.generator.configuration.outlet.TypedOutletSaxHandlerFactory;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OutletConfigurationXmlParser {
    private static SAXParserFactory saxFactory;
    private static Log log;

    public OutletConfiguration readOutletConfiguration(ConfigurationProvider configurationProvider, ConfigurationHandlers configurationHandlers, UnitDescriptor unitDescriptor) throws ConfigurationException {
        if (configurationHandlers == null) {
            log.error((Object)"OutletConfiguration:  configurationHandlers is null");
            throw new NullPointerException("configurationHandlers is null");
        }
        if (configurationProvider == null) {
            log.error((Object)"OutletConfiguration:  configurationProvider is null");
            throw new NullPointerException("configurationProvider is null");
        }
        ArrayList<Outlet> allOutlets = new ArrayList<Outlet>();
        ArrayList<MergepointMapping> allMergepointMappings = new ArrayList<MergepointMapping>();
        Collection<String> outletConfigNames = configurationProvider.getOutletConfigurationNames();
        for (String outletConfigName : outletConfigNames) {
            try {
                InputStream inputStream = configurationProvider.getOutletConfigurationInputStream(outletConfigName);
                try {
                    OutletConfigFileContent fileContent = this.readOutletConfig(inputStream, configurationProvider, unitDescriptor, configurationHandlers);
                    allOutlets.addAll(fileContent.getOutlets());
                    allMergepointMappings.addAll(fileContent.getMergepointMappings());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (SAXParseException e) {
                throw new ConfigurationException("Error parsing outlet configuration " + outletConfigName + " at line " + e.getLineNumber() + " column " + e.getColumnNumber() + " : " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error parsing outlet configuration " + outletConfigName, e);
            }
        }
        this.scanTemplatesForOutlets(allOutlets, configurationProvider, configurationHandlers);
        return new OutletConfiguration(allOutlets, allMergepointMappings, unitDescriptor);
    }

    private OutletConfigFileContent readOutletConfig(InputStream outletConfigurationInputStream, ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws SAXException, IOException, ParserConfigurationException, ConfigurationException {
        SAXParser parser = saxFactory.newSAXParser();
        OutletConfigurationSaxHandler saxHandler = new OutletConfigurationSaxHandler(configurationProvider, unitDescriptor, configurationHandlers);
        InputSource is = new InputSource(outletConfigurationInputStream);
        parser.parse(is, (DefaultHandler)saxHandler);
        ArrayList<Outlet> outlets = new ArrayList<Outlet>();
        outlets.addAll(saxHandler.getOutlets());
        return new OutletConfigFileContent(outlets, saxHandler.getMergepointMappings());
    }

    private void scanTemplatesForOutlets(List<Outlet> outlets, ConfigurationProvider configurationProvider, ConfigurationHandlers configurationHandlers) throws ConfigurationException {
        HashSet<QualifiedName> outletNames = new HashSet<QualifiedName>();
        for (Outlet outlet : outlets) {
            outletNames.add(outlet.getName());
        }
        Collection<String> templateFileNames = configurationProvider.getTemplateNames();
        for (String templateFileName : templateFileNames) {
            Collection<TypedOutletSaxHandlerFactory> outletSaxHandlerFactories = configurationHandlers.getOutletTypes().getTypedOutletHandlerFactories().values();
            for (TypedOutletSaxHandlerFactory outletSaxHandlerFactory : outletSaxHandlerFactories) {
                for (String suffix : outletSaxHandlerFactory.getTemplatesFilenameExtensionsForScan()) {
                    Outlet outlet;
                    QualifiedName outletName;
                    if (!templateFileName.endsWith(suffix) || outletNames.contains(outletName = (outlet = outletSaxHandlerFactory.createOutletForTemplate(templateFileName, configurationProvider)).getName())) continue;
                    outlets.add(outlet);
                    outletNames.add(outletName);
                }
            }
        }
    }

    static QualifiedName getOutletNameForFilename(String path) {
        String resultName = path;
        int dotIndex = resultName.lastIndexOf(46);
        if (dotIndex != -1) {
            resultName = resultName.substring(0, dotIndex);
        }
        resultName = resultName.replace('/', '.');
        resultName = resultName.replace('\\', '.');
        QualifiedName result = new QualifiedName(resultName);
        return result;
    }

    static {
        log = LogFactory.getLog(OutletConfigurationXmlParser.class);
        saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        try {
            saxFactory.setFeature("http://xml.org/sax/features/validation", true);
            saxFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class OutletConfigFileContent {
        private final List<Outlet> outlets;
        private final List<MergepointMapping> mergepointMappings;

        public OutletConfigFileContent(List<Outlet> outlets, List<MergepointMapping> mergepointMappings) {
            this.outlets = outlets;
            this.mergepointMappings = mergepointMappings;
        }

        public List<Outlet> getOutlets() {
            return this.outlets;
        }

        public List<MergepointMapping> getMergepointMappings() {
            return this.mergepointMappings;
        }
    }
}

