/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import org.apache.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTargetAttributeTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;

public class CopyAttributeTransformer
extends SourceTargetAttributeTransformer {
    private static Logger log = Logger.getLogger(CopyAttributeTransformer.class);

    @Override
    public SourceElement transform(Object rootObject, ControllerState controllerState) throws SourceTransformerException {
        if (!(rootObject instanceof SourceElement)) {
            throw new SourceTransformerException("rootObject is not a SourceElement but has the class " + rootObject.getClass().getName());
        }
        SourceElement sourceElement = (SourceElement)rootObject;
        String sourceAttributeName = this.getSourceAttributeName();
        if (sourceAttributeName == null) {
            throw new IllegalStateException("sourceAttributeName is not set");
        }
        String targetAttributeName = this.getTargetAttributeName();
        if (targetAttributeName == null) {
            throw new IllegalStateException("targetAttributeName is not set");
        }
        Object attributeValue = sourceElement.getAttribute(sourceAttributeName);
        if (attributeValue == null) {
            log.debug((Object)("Attribute " + sourceAttributeName + " is not set, no changes made"));
            return sourceElement;
        }
        if (this.isOverwrite() || sourceElement.getAttribute(targetAttributeName) == null) {
            sourceElement.setAttribute(targetAttributeName, attributeValue);
        }
        return sourceElement;
    }
}

