/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.objectbuilder;

import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.PreparedStatementPartImpl;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.UniqueList;

public class PreparedStatementPartForSubselect
implements PreparedStatementPart {
    private PreparedStatementPartImpl wrapped;
    private final Criteria toBuildFrom;
    private final Query outerQuery;

    public PreparedStatementPartForSubselect(Criteria toBuildFrom, Query outerQuery) {
        this.toBuildFrom = toBuildFrom;
        this.outerQuery = outerQuery;
    }

    private void calculate() {
        Query subquery;
        try {
            subquery = SqlBuilder.buildQuery(this.toBuildFrom);
        }
        catch (TorqueException e) {
            throw new TorqueRuntimeException(e);
        }
        UniqueList<FromElement> remainingTableNames = new UniqueList<FromElement>(subquery.getFromClause());
        remainingTableNames.removeAll(this.outerQuery.getFromClause());
        if (remainingTableNames.size() > 0) {
            subquery.getFromClause().removeAll(this.outerQuery.getFromClause());
        }
        PreparedStatementPartImpl result = new PreparedStatementPartImpl("(" + subquery.toString() + ")", new Object[0]);
        result.getPreparedStatementReplacements().addAll(subquery.getPreparedStatementReplacements());
        this.wrapped = result;
    }

    @Override
    public String getSqlAsString() {
        if (this.wrapped == null) {
            this.calculate();
        }
        return this.wrapped.getSqlAsString();
    }

    @Override
    public List<Object> getPreparedStatementReplacements() {
        if (this.wrapped == null) {
            this.calculate();
        }
        return this.wrapped.getPreparedStatementReplacements();
    }
}

