/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.torque.generator.configuration.controller.LoggingAdapter;
import org.apache.torque.generator.configuration.controller.Loglevel;

public class Log4jLoggingAdapter
implements LoggingAdapter {
    private static Log log = LogFactory.getLog(Log4jLoggingAdapter.class);
    private static final Map<Loglevel, Level> LOG4J_LEVELS;

    public Loglevel getCurrentLoglevel() {
        Level level = Logger.getRootLogger().getLevel();
        for (Map.Entry<Loglevel, Level> loglevel : LOG4J_LEVELS.entrySet()) {
            if (!loglevel.getValue().equals((Object)level)) continue;
            return loglevel.getKey();
        }
        return Loglevel.INFO;
    }

    public void setLoglevel(Loglevel loglevel) {
        if (loglevel == null) {
            return;
        }
        Level log4jLevel = LOG4J_LEVELS.get((Object)loglevel);
        if (Logger.getRootLogger().getLevel() != LOG4J_LEVELS.get((Object)loglevel)) {
            log.info((Object)("apply() : Setting loglevel to " + (Object)((Object)loglevel)));
            Logger.getRootLogger().setLevel(log4jLevel);
        }
    }

    static {
        HashMap<Loglevel, Level> log4jLevels = new HashMap<Loglevel, Level>();
        log4jLevels.put(Loglevel.TRACE, Level.TRACE);
        log4jLevels.put(Loglevel.DEBUG, Level.DEBUG);
        log4jLevels.put(Loglevel.INFO, Level.INFO);
        log4jLevels.put(Loglevel.WARN, Level.WARN);
        log4jLevels.put(Loglevel.ERROR, Level.ERROR);
        LOG4J_LEVELS = Collections.unmodifiableMap(log4jLevels);
    }
}

