/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractChildNode;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCharacterData
extends AbstractChildNode
implements CharacterData {
    protected String nodeValue = "";

    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    public void setNodeValue(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string2 = this.nodeValue;
        this.nodeValue = string == null ? "" : string;
        this.fireDOMCharacterDataModifiedEvent(string2, this.nodeValue);
        if (this.getParentNode() != null) {
            ((AbstractParentNode)this.getParentNode()).fireDOMSubtreeModifiedEvent();
        }
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public int getLength() {
        return this.nodeValue.length();
    }

    public String substringData(int n, int n2) throws DOMException {
        this.checkOffsetCount(n, n2);
        String string = this.getNodeValue();
        return string.substring(n, Math.min(string.length(), n + n2));
    }

    public void appendData(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.setNodeValue(this.getNodeValue() + (string == null ? "" : string));
    }

    public void insertData(int n, String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (n < 0 || n > this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{new Integer(n)});
        }
        String string2 = this.getNodeValue();
        this.setNodeValue(string2.substring(0, n) + string + string2.substring(n, string2.length()));
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.checkOffsetCount(n, n2);
        String string = this.getNodeValue();
        this.setNodeValue(string.substring(0, n) + string.substring(Math.min(string.length(), n + n2), string.length()));
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.checkOffsetCount(n, n2);
        String string2 = this.getNodeValue();
        this.setNodeValue(string2.substring(0, n) + string + string2.substring(Math.min(string2.length(), n + n2), string2.length()));
    }

    protected void checkOffsetCount(int n, int n2) throws DOMException {
        if (n < 0 || n >= this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{new Integer(n)});
        }
        if (n2 < 0) {
            throw this.createDOMException((short)1, "negative.count", new Object[]{new Integer(n2)});
        }
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }
}

