/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractSVGGradientElementBridge
extends AbstractSVGBridge
implements PaintBridge,
ErrorConstants {
    protected AbstractSVGGradientElementBridge() {
    }

    public Paint createPaint(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, float f) {
        Object object;
        List list = AbstractSVGGradientElementBridge.extractStop(element, f, bridgeContext);
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 1) {
            return ((Stop)list.get((int)0)).color;
        }
        float[] fArray = new float[n];
        Color[] colorArray = new Color[n];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = (Stop)iterator.next();
            fArray[n2] = ((Stop)object).offset;
            colorArray[n2] = ((Stop)object).color;
            ++n2;
        }
        object = MultipleGradientPaint.NO_CYCLE;
        String string = SVGUtilities.getChainableAttributeNS(element, null, "spreadMethod", bridgeContext);
        if (string.length() != 0) {
            object = AbstractSVGGradientElementBridge.convertSpreadMethod(element, string);
        }
        MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum = CSSUtilities.convertColorInterpolation(element);
        string = SVGUtilities.getChainableAttributeNS(element, null, "gradientTransform", bridgeContext);
        AffineTransform affineTransform = string.length() != 0 ? SVGUtilities.convertTransform(element, "gradientTransform", string) : new AffineTransform();
        Paint paint = this.buildGradient(element, element2, graphicsNode, (MultipleGradientPaint.CycleMethodEnum)object, colorSpaceEnum, affineTransform, colorArray, fArray, bridgeContext);
        return paint;
    }

    protected abstract Paint buildGradient(Element var1, Element var2, GraphicsNode var3, MultipleGradientPaint.CycleMethodEnum var4, MultipleGradientPaint.ColorSpaceEnum var5, AffineTransform var6, Color[] var7, float[] var8, BridgeContext var9);

    protected static MultipleGradientPaint.CycleMethodEnum convertSpreadMethod(Element element, String string) {
        if ("repeat".equals(string)) {
            return MultipleGradientPaint.REPEAT;
        }
        if ("reflect".equals(string)) {
            return MultipleGradientPaint.REFLECT;
        }
        if ("pad".equals(string)) {
            return MultipleGradientPaint.NO_CYCLE;
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{"spreadMethod", string});
    }

    protected static List extractStop(Element element, float f, BridgeContext bridgeContext) {
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        List list;
        while ((list = AbstractSVGGradientElementBridge.extractLocalStop(element, f, bridgeContext)) == null) {
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return null;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (!parsedURL.complete()) {
                throw new BridgeException(element, "uri.malformed", new Object[]{string});
            }
            if (AbstractSVGGradientElementBridge.contains(linkedList, parsedURL)) {
                throw new BridgeException(element, "xlink.href.circularDependencies", new Object[]{string});
            }
            linkedList.add(parsedURL);
            element = bridgeContext.getReferencedElement(element, string);
        }
        return list;
    }

    protected static List extractLocalStop(Element element, float f, BridgeContext bridgeContext) {
        LinkedList<Stop> linkedList = null;
        Stop stop = null;
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            Bridge bridge;
            if (node.getNodeType() == 1 && (bridge = bridgeContext.getBridge(element2 = (Element)node)) != null && bridge instanceof SVGStopElementBridge) {
                Stop stop2 = ((SVGStopElementBridge)bridge).createStop(bridgeContext, element, element2, f);
                if (linkedList == null) {
                    linkedList = new LinkedList<Stop>();
                }
                if (stop != null && stop2.offset < stop.offset) {
                    stop2.offset = stop.offset;
                }
                linkedList.add(stop2);
                stop = stop2;
            }
            node = node.getNextSibling();
        }
        return linkedList;
    }

    private static boolean contains(List list, ParsedURL parsedURL) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!parsedURL.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static class SVGStopElementBridge
    extends AbstractSVGBridge
    implements Bridge {
        public String getLocalName() {
            return "stop";
        }

        public Stop createStop(BridgeContext bridgeContext, Element element, Element element2, float f) {
            float f2;
            String string = element2.getAttributeNS(null, "offset");
            if (string.length() == 0) {
                throw new BridgeException(element2, "attribute.missing", new Object[]{"offset"});
            }
            try {
                f2 = SVGUtilities.convertRatio(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(element2, "attribute.malformed", new Object[]{"offset", string, numberFormatException});
            }
            Color color = CSSUtilities.convertStopColor(element2, f, bridgeContext);
            return new Stop(color, f2);
        }
    }

    public static class Stop {
        public Color color;
        public float offset;

        public Stop(Color color, float f) {
            this.color = color;
            this.offset = f;
        }
    }
}

