/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public SimpleFSDirectory(File path) throws IOException {
        super(path, null);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File path = new File(this.directory, name);
        return new SimpleFSIndexInput("SimpleFSIndexInput(path=\"" + path.getPath() + "\")", path, context);
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(String name, final IOContext context) throws IOException {
        this.ensureOpen();
        final File file = new File(this.getDirectory(), name);
        final RandomAccessFile descriptor = new RandomAccessFile(file, "r");
        return new Directory.IndexInputSlicer(){

            @Override
            public void close() throws IOException {
                descriptor.close();
            }

            @Override
            public IndexInput openSlice(String sliceDescription, long offset, long length) {
                return new SimpleFSIndexInput("SimpleFSIndexInput(" + sliceDescription + " in path=\"" + file.getPath() + "\" slice=" + offset + ":" + (offset + length) + ")", descriptor, offset, length, BufferedIndexInput.bufferSize(context));
            }

            @Override
            public IndexInput openFullSlice() {
                try {
                    return this.openSlice("full-slice", 0L, descriptor.length());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    protected static class SimpleFSIndexInput
    extends FSDirectory.FSIndexInput {
        private static final int CHUNK_SIZE = 8192;

        public SimpleFSIndexInput(String resourceDesc, File path, IOContext context) throws IOException {
            super(resourceDesc, path, context);
        }

        public SimpleFSIndexInput(String resourceDesc, RandomAccessFile file, long off, long length, int bufferSize) {
            super(resourceDesc, file, off, length, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                long position = this.off + this.getFilePointer();
                this.file.seek(position);
                if (position + (long)len > this.end) {
                    throw new EOFException("read past EOF: " + this);
                }
                try {
                    int total;
                    int i;
                    for (total = 0; total < len; total += i) {
                        int toRead = Math.min(8192, len - total);
                        i = this.file.read(b, offset + total, toRead);
                        if (i < 0) {
                            throw new EOFException("read past EOF: " + this + " off: " + offset + " len: " + len + " total: " + total + " chunkLen: " + toRead + " end: " + this.end);
                        }
                        assert (i > 0) : "RandomAccessFile.read with non zero-length toRead must always read at least one byte";
                    }
                    assert (total == len);
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ": " + this, ioe);
                }
            }
        }

        @Override
        protected void seekInternal(long position) {
        }
    }
}

