/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MathTrigFunctionsTest
extends BaseJDBCTestCase {
    private static final double PRE_DERBY_3398_SMALLEST_NEG_DERBY_DOUBLE = -1.79769E308;
    private static final double SMALL_NEG_DOUBLE = -1.79768E308;
    private static final double PRE_DERBY_3398_SMALLEST_POS_DERBY_DOUBLE = 2.225E-307;
    private static final double PRE_DERBY_3398_LARGEST_POS_DERBY_DOUBLE = 1.79769E308;
    private static final double PRE_DERBY_3398_LARGEST_NEG_DERBY_DOUBLE = -2.225E-307;
    private static final double[] testRadians = new double[]{-1.0E-9, -0.25, 1.0E-9, 0.25, 0.5, 0.0, 1.0, 2.0, Math.PI, Math.PI};
    private static final double[] testArcValues = new double[]{1.0E-9, -1.0E-9, 0.25, -0.25, 0.5, 0.0, -0.0, 1.0, -1.0};
    private static final double[] logValues = new double[]{1.0E-9, 0.25, 0.5, 1.0, 45.0, 90.0, 135.0, 180.0, 270.0, 2.225E-307, 1.79769E308, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static final double[] testValues = new double[]{-1.79769E308, -1.79768E308, 2.225E-307, 1.79769E308, -2.225E-307, 1.0E-9, -1.0E-9, 0.25, -0.25, 0.5, 0.0, -0.0, 1.0, -1.0, 2.0, 3.0, Math.PI, Math.PI * 2, 4.0, 45.0, 90.0, 135.0, 180.0, 270.0};
    private static final double[] testValuesTwo = new double[]{-1.79769E308, -1.79768E308, 2.225E-307, -2.225E-307, 1.0E-9, -1.0E-9, 0.25, -0.25, 0.5, 0.0, -0.0, 1.0, -1.0, 2.0, 3.0, Math.PI, Math.PI * 2, 4.0, 45.0, 90.0, 135.0, 180.0, 270.0};
    static final double DOUBLE_MIN_NORMAL = Double.MIN_NORMAL;

    public void testAcos() throws SQLException {
        this.executeNullValues("ACOS");
        this.executeNullFn("ACOS");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES ACOS(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn ACOS(?)}");
        for (int i = 0; i < testArcValues.length; ++i) {
            double expected = StrictMath.acos(testArcValues[i]);
            double rValue = this.getValue(ps, testArcValues[i]);
            this.debug("ACOS: input value: " + testArcValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testArcValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.acos(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        try {
            this.getValue(ps, 2.0);
            MathTrigFunctionsTest.fail((String)"ACOS: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, 2.0);
            MathTrigFunctionsTest.fail((String)"ACOS: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
        psFN.close();
    }

    public void testAsin() throws SQLException {
        this.executeNullValues("ASIN");
        this.executeNullFn("ASIN");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES ASIN(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn ASIN(?)}");
        for (int i = 0; i < testArcValues.length; ++i) {
            double expected = StrictMath.asin(testArcValues[i]);
            double rValue = this.getValue(ps, testArcValues[i]);
            this.debug("ASIN: input value: " + testArcValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testArcValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.asin(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        try {
            this.getValue(ps, 2.0);
            MathTrigFunctionsTest.fail((String)"ASIN: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, 2.0);
            MathTrigFunctionsTest.fail((String)"ASIN: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
        psFN.close();
    }

    public void testAtan() throws SQLException {
        this.executeNullValues("ATAN");
        this.executeNullFn("ATAN");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES ATAN(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn ATAN(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.atan(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("ATAN: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.atan(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    public void testCos() throws SQLException {
        this.executeNullValues("COS");
        this.executeNullFn("COS");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES COS(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn COS(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.cos(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("COS: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.cos(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    public void testSin() throws SQLException {
        this.executeNullValues("SIN");
        this.executeNullFn("SIN");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES SIN(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn SIN(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.sin(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("SIN: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.sin(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    public void testTan() throws SQLException {
        this.executeNullValues("TAN");
        this.executeNullFn("TAN");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES TAN(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn TAN(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.tan(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("TAN: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.tan(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    public void testCot() throws SQLException {
        this.executeNullValues("COT");
        this.executeNullFn("COT");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES COT(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn COT(?)}");
        for (double value : testValues) {
            this.checkResult(ps, value, 1.0 / StrictMath.tan(value));
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expected = 1.0 / StrictMath.tan(randD);
            this.checkResult(ps, randD, expected);
            this.checkResult(psFN, randD, expected);
        }
    }

    private void checkResult(PreparedStatement ps, double input, double expected) throws SQLException {
        if (expected == -0.0) {
            expected = 0.0;
        }
        ps.setDouble(1, input);
        if (Double.isNaN(expected) || Double.isInfinite(expected)) {
            this.debug("input value: " + input + " expected value: " + expected + " : OUT OF RANGE");
            MathTrigFunctionsTest.assertStatementError("22003", ps);
        } else {
            this.debug("input value: " + input + " expected value: " + expected);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), String.valueOf(expected));
        }
    }

    public void testCosh() throws SQLException {
        this.executeNullValues("COSH");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES COSH(?)");
        this.assertCompileError("42X01", "VALUES {fn COSH(?)}");
        for (double value : testValues) {
            this.checkResult(ps, value, StrictMath.cosh(value));
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.cosh(randD);
            this.checkResult(ps, randD, expect);
        }
    }

    public void testSinh() throws SQLException {
        this.executeNullValues("SINH");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES SINH(?)");
        this.assertCompileError("42X01", "VALUES {fn SINH(?)}");
        for (double value : testValues) {
            this.checkResult(ps, value, StrictMath.sinh(value));
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.sinh(randD);
            this.checkResult(ps, randD, expect);
        }
    }

    public void testTanh() throws SQLException {
        this.executeNullValues("TANH");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES TANH(?)");
        this.assertCompileError("42X01", "VALUES {fn TANH(?)}");
        for (double value : testValues) {
            this.checkResult(ps, value, StrictMath.tanh(value));
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.tanh(randD);
            this.checkResult(ps, randD, expect);
        }
    }

    public void testPI() throws SQLException {
        double value = this.executeValues("PI");
        MathTrigFunctionsTest.assertEquals((double)Math.PI, (double)value, (double)0.0);
        double fValue = this.executeFn("PI");
        MathTrigFunctionsTest.assertEquals((double)Math.PI, (double)fValue, (double)0.0);
        try {
            this.executeValues("PI", 2.0);
            MathTrigFunctionsTest.fail((String)"PI: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("42Y03", sqlE);
        }
        try {
            this.executeFn("PI", 2.0);
            MathTrigFunctionsTest.fail((String)"PI: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("42Y03", sqlE);
        }
    }

    public void testDegrees() throws SQLException {
        this.executeNullValues("DEGREES");
        this.executeNullFn("DEGREES");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES DEGREES(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn DEGREES(?)}");
        for (int i = 0; i < testRadians.length; ++i) {
            double expected = StrictMath.toDegrees(testRadians[i]);
            double rValue = this.getValue(ps, testRadians[i]);
            this.debug("DEGREES: input value: " + testRadians[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testRadians[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.toDegrees(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        try {
            this.getValue(ps, -1.79769E308);
            MathTrigFunctionsTest.fail((String)"DEGREES: Out of range test failed, input value is: -1.79769E308");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, -1.79769E308);
            MathTrigFunctionsTest.fail((String)"DEGREES: Out of range test failed, input value is: -1.79769E308");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
        psFN.close();
    }

    public void testRadians() throws SQLException {
        this.executeNullValues("RADIANS");
        this.executeNullFn("RADIANS");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES RADIANS(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn RADIANS(?)}");
        for (int i = 0; i < testArcValues.length; ++i) {
            double expected = StrictMath.toRadians(testArcValues[i]);
            double rValue = this.getValue(ps, testArcValues[i]);
            this.debug("RADIANS: input value: " + testArcValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testArcValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.toRadians(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        double[][] inOut = new double[][]{{180.0, Math.PI}, {-1.79769E308, -3.1375609430176863E306}, {Double.MIN_NORMAL, 3.8834864931005E-310}, {Double.MIN_VALUE, 0.0}, {Double.MAX_VALUE, 3.1375664143845866E306}, {2.225E-307, MathTrigFunctionsTest.vmAtLeast(1, 9) ? 3.883357585687384E-309 : 3.88335758568738E-309}, {-2.225E-307, MathTrigFunctionsTest.vmAtLeast(1, 9) ? -3.883357585687384E-309 : -3.88335758568738E-309}};
        for (int i = 0; i < inOut.length; ++i) {
            double dv = this.getValue(ps, inOut[i][0]);
            MathTrigFunctionsTest.assertEquals((double)inOut[i][1], (double)dv, (double)0.0);
            dv = this.getValue(psFN, inOut[i][0]);
            MathTrigFunctionsTest.assertEquals((double)inOut[i][1], (double)dv, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    public void testExp() throws SQLException {
        this.executeNullValues("EXP");
        this.executeNullFn("EXP");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES EXP(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn EXP(?)}");
        for (int i = 0; i < testValuesTwo.length; ++i) {
            double expected = StrictMath.exp(testValuesTwo[i]);
            double rValue = this.getValue(ps, testValuesTwo[i]);
            this.debug("EXP: input value: " + testValuesTwo[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValuesTwo[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.exp(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        try {
            this.getValue(ps, 1.79769E308);
            MathTrigFunctionsTest.fail((String)"EXP: Out of range test failed, input value is: 1.79769E308");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, 1.79769E308);
            MathTrigFunctionsTest.fail((String)"EXP: Out of range test failed, input value is: 1.79769E308");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
        psFN.close();
    }

    public void testLog10() throws SQLException {
        this.executeNullValues("LOG10");
        this.executeNullFn("LOG10");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES LOG10(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn LOG10(?)}");
        for (int i = 0; i < logValues.length; ++i) {
            double expected = StrictMath.log10(logValues[i]);
            double rValue = this.getValue(ps, logValues[i]);
            this.debug("LOG10: input value: " + logValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, logValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.log10(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        try {
            this.getValue(ps, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(ps, -1.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: -1.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, -1.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: -1.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
        psFN.close();
    }

    public void testLog() throws SQLException {
        this.executeNullValues("LOG");
        this.executeNullFn("LOG");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES LOG(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn LOG(?)}");
        for (int i = 0; i < logValues.length; ++i) {
            double expected = StrictMath.log(logValues[i]);
            double rValue = this.getValue(ps, logValues[i]);
            this.debug("LOG: input value: " + logValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, logValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.log(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        try {
            this.getValue(ps, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        try {
            this.getValue(psFN, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
        psFN.close();
    }

    public void testLn() throws SQLException {
        this.executeNullValues("LN");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES LN(?)");
        for (int i = 0; i < logValues.length; ++i) {
            double expected = StrictMath.log(logValues[i]);
            double rValue = this.getValue(ps, logValues[i]);
            this.debug("LOG: input value: " + logValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.log(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
        }
        try {
            this.getValue(ps, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sqlE) {
            MathTrigFunctionsTest.assertSQLState("22003", sqlE);
        }
        ps.close();
    }

    public void testCeil() throws SQLException {
        this.executeNullValues("CEIL");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES CEIL(?)");
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.ceil(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("CEIL: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.ceil(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
        }
        ps.close();
    }

    public void testCeiling() throws SQLException {
        this.executeNullValues("CEILING");
        this.executeNullFn("CEILING");
        PreparedStatement ps = this.prepareStatement("VALUES CEILING(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn CEILING(?)}");
        this.debug();
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.ceil(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("CEILING: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.ceil(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    public void testFloor() throws SQLException {
        this.executeNullValues("FLOOR");
        this.executeNullFn("FLOOR");
        this.debug();
        PreparedStatement ps = this.prepareStatement("VALUES FLOOR(?)");
        PreparedStatement psFN = this.prepareStatement("VALUES {fn FLOOR(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double expected = StrictMath.floor(testValues[i]);
            double rValue = this.getValue(ps, testValues[i]);
            this.debug("FLOOR: input value: " + testValues[i] + " expected value: " + expected + " return value: " + rValue);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)rValue, (double)0.0);
            double fValue = this.getValue(psFN, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)expected, (double)fValue, (double)0.0);
        }
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            double randD = rand.nextDouble();
            double expect = StrictMath.floor(randD);
            double rVal = this.getValue(ps, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)rVal, (double)0.0);
            double fVal = this.getValue(psFN, randD);
            MathTrigFunctionsTest.assertEquals((double)expect, (double)fVal, (double)0.0);
        }
        ps.close();
        psFN.close();
    }

    private double executeValues(String functionName) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values " + functionName + "()");
        double rValue = 0.0;
        while (rs.next()) {
            rValue = rs.getDouble(1);
        }
        rs.close();
        stmt.close();
        return rValue;
    }

    private double executeValues(String functionName, double value) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values " + functionName + "(" + value + ")");
        double rValue = 0.0;
        while (rs.next()) {
            rValue = rs.getDouble(1);
        }
        rs.close();
        stmt.close();
        return rValue;
    }

    private double getValue(PreparedStatement ps, double value) throws SQLException {
        ps.setDouble(1, value);
        ResultSet rs = ps.executeQuery();
        rs.next();
        double rValue = rs.getDouble(1);
        rs.close();
        return rValue;
    }

    private void executeNullValues(String functionName) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values " + functionName + "(null)");
        rs.next();
        MathTrigFunctionsTest.assertNull((Object)rs.getObject(1));
        MathTrigFunctionsTest.assertTrue((boolean)rs.wasNull());
        rs.close();
        stmt.close();
    }

    private double executeFn(String functionName) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values {fn " + functionName + "()}");
        double rValue = 0.0;
        while (rs.next()) {
            rValue = rs.getDouble(1);
        }
        rs.close();
        stmt.close();
        return rValue;
    }

    private double executeFn(String functionName, double value) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values {fn  " + functionName + "(" + value + ")}");
        double rValue = 0.0;
        while (rs.next()) {
            rValue = rs.getDouble(1);
        }
        rs.close();
        stmt.close();
        return rValue;
    }

    private void executeNullFn(String functionName) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values {fn  " + functionName + "(null)}");
        rs.next();
        MathTrigFunctionsTest.assertNull((Object)rs.getObject(1));
        MathTrigFunctionsTest.assertTrue((boolean)rs.wasNull());
        rs.close();
        stmt.close();
    }

    private void debug(String message) {
        MathTrigFunctionsTest.println(message);
    }

    private void debug() {
        MathTrigFunctionsTest.println("");
    }

    public MathTrigFunctionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(MathTrigFunctionsTest.class);
    }
}

