/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DestroySlaveDB
extends BaseJDBCTestCase {
    private static String slaveServerHost = null;
    private static ReplicationRun repRun = new ReplicationRun("DestroySlaveDB");

    public DestroySlaveDB(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** DestroySlaveDB.suite()");
        System.out.println("'DestroySlaveDB' can not be run outside the 'ReplicationRun' framework.");
        BaseTestSuite suite = new BaseTestSuite("DestroySlaveDB");
        String masterHostName = System.getProperty("test.serverHost", "localhost");
        int masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        repRun.initEnvironment();
        slaveServerHost = ReplicationRun.slaveServerHost;
        suite.addTest(DestroySlaveDB.suite(masterHostName, masterPortNo));
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** DestroySlaveDB.suite(" + serverHost + "," + serverPort + ")");
        Test t = TestConfiguration.existingServerSuite(DestroySlaveDB.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.existingServerSuite(DestroySlaveDB.class,false," + serverHost + "," + serverPort + ")");
        return t;
    }

    public void testDestroySlaveDB() throws SQLException, IOException, InterruptedException {
        System.out.println("**** DestroySlaveDB.testDestroySlaveDB() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement pSt = this.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < 1000; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "i" + i);
            pSt.execute();
            System.out.println("i: " + i);
            if (i != 500) continue;
            repRun.destroySlaveDB(slaveServerHost);
        }
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }
}

