/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.thetacommon.HashOperations;

final class ThetaIntersectionImpl
extends ThetaIntersection {
    private final short seedHash_;
    private final boolean readOnly_;
    private final MemorySegment wseg_;
    private final int maxLgArrLongs_;
    private int lgArrLongs_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private long[] hashTable_;

    private ThetaIntersectionImpl(MemorySegment wseg, long seed, boolean dstSegFlag, boolean readOnly) {
        this.readOnly_ = readOnly;
        if (wseg != null) {
            this.wseg_ = wseg;
            if (dstSegFlag) {
                ThetaIntersectionImpl.checkMinSizeMemorySegment(wseg);
                this.maxLgArrLongs_ = !readOnly ? ThetaIntersectionImpl.getMaxLgArrLongs(wseg) : 0;
                this.seedHash_ = Util.computeSeedHash(seed);
                this.wseg_.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, this.seedHash_);
            } else {
                this.seedHash_ = this.wseg_.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L);
                Util.checkSeedHashes(this.seedHash_, Util.computeSeedHash(seed));
                this.maxLgArrLongs_ = 0;
            }
        } else {
            this.wseg_ = null;
            this.maxLgArrLongs_ = 0;
            this.seedHash_ = Util.computeSeedHash(seed);
        }
    }

    static ThetaIntersectionImpl initNewHeapInstance(long seed) {
        boolean dstSegFlag = false;
        boolean readOnly = false;
        ThetaIntersectionImpl impl = new ThetaIntersectionImpl(null, seed, false, false);
        impl.hardReset();
        return impl;
    }

    static ThetaIntersectionImpl initNewDirectInstance(long seed, MemorySegment dstSeg) {
        dstSeg.asSlice(0L, 24L).fill((byte)0);
        PreambleUtil.insertPreLongs(dstSeg, 3);
        PreambleUtil.insertSerVer(dstSeg, 3);
        PreambleUtil.insertFamilyID(dstSeg, Family.INTERSECTION.getID());
        PreambleUtil.insertP(dstSeg, 1.0f);
        boolean dstSegFlag = true;
        boolean readOnly = false;
        ThetaIntersectionImpl impl = new ThetaIntersectionImpl(dstSeg, seed, true, false);
        impl.hardReset();
        return impl;
    }

    static ThetaIntersectionImpl heapifyInstance(MemorySegment srcSeg, long seed) {
        boolean dstSegFlag = false;
        boolean readOnly = false;
        ThetaIntersectionImpl.segChecks(srcSeg);
        ThetaIntersectionImpl impl = new ThetaIntersectionImpl(null, seed, false, false);
        impl.lgArrLongs_ = PreambleUtil.extractLgArrLongs(srcSeg);
        impl.curCount_ = PreambleUtil.extractCurCount(srcSeg);
        impl.thetaLong_ = PreambleUtil.extractThetaLong(srcSeg);
        boolean bl = impl.empty_ = (PreambleUtil.extractFlags(srcSeg) & 4) > 0;
        if (!impl.empty_ && impl.curCount_ > 0) {
            impl.hashTable_ = new long[1 << impl.lgArrLongs_];
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG_UNALIGNED, 24L, impl.hashTable_, 0, 1 << impl.lgArrLongs_);
        }
        return impl;
    }

    static ThetaIntersectionImpl wrapInstance(MemorySegment srcSeg, long seed, boolean readOnly) {
        boolean dstSegFlag = false;
        ThetaIntersectionImpl.segChecks(srcSeg);
        ThetaIntersectionImpl impl = new ThetaIntersectionImpl(srcSeg, seed, false, readOnly);
        impl.lgArrLongs_ = PreambleUtil.extractLgArrLongs(srcSeg);
        impl.curCount_ = PreambleUtil.extractCurCount(srcSeg);
        impl.thetaLong_ = PreambleUtil.extractThetaLong(srcSeg);
        impl.empty_ = (PreambleUtil.extractFlags(srcSeg) & 4) > 0;
        return impl;
    }

    @Override
    public CompactThetaSketch intersect(ThetaSketch a, ThetaSketch b, boolean dstOrdered, MemorySegment dstSeg) {
        if (this.wseg_ != null && this.readOnly_) {
            throw new SketchesReadOnlyException();
        }
        this.hardReset();
        this.intersect(a);
        this.intersect(b);
        CompactThetaSketch csk = this.getResult(dstOrdered, dstSeg);
        this.hardReset();
        return csk;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void intersect(ThetaSketch sketchIn) {
        if (sketchIn == null) {
            throw new SketchesArgumentException("The input argument must not be null.");
        }
        if (this.wseg_ != null && this.readOnly_) {
            throw new SketchesReadOnlyException();
        }
        if (this.empty_ || sketchIn.isEmpty()) {
            this.resetToEmpty();
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
        this.empty_ = false;
        if (this.wseg_ != null) {
            PreambleUtil.insertThetaLong(this.wseg_, this.thetaLong_);
            PreambleUtil.clearEmpty(this.wseg_);
        }
        int sketchInEntries = sketchIn.getRetainedEntries(true);
        if (this.curCount_ == 0 || sketchInEntries == 0) {
            this.curCount_ = 0;
            if (this.wseg_ != null) {
                PreambleUtil.insertCurCount(this.wseg_, 0);
            }
            this.hashTable_ = null;
            return;
        }
        if (this.curCount_ < 0 && sketchInEntries > 0) {
            this.curCount_ = sketchIn.getRetainedEntries(true);
            int requiredLgArrLongs = HashOperations.minLgHashTableSize(this.curCount_, 0.9375);
            int priorLgArrLongs = this.lgArrLongs_;
            this.lgArrLongs_ = requiredLgArrLongs;
            if (this.wseg_ != null) {
                PreambleUtil.insertCurCount(this.wseg_, this.curCount_);
                PreambleUtil.insertLgArrLongs(this.wseg_, this.lgArrLongs_);
                if (requiredLgArrLongs > this.maxLgArrLongs_) {
                    int requiredBytes = (8 << requiredLgArrLongs) + 24;
                    int givenBytes = (8 << priorLgArrLongs) + 24;
                    throw new SketchesArgumentException("Insufficient internal MemorySegment space: " + requiredBytes + " > " + givenBytes);
                }
                this.wseg_.asSlice(24L, 8 << this.lgArrLongs_).fill((byte)0);
            } else {
                this.hashTable_ = new long[1 << this.lgArrLongs_];
            }
            this.moveDataToTgt(sketchIn);
            return;
        }
        if (this.curCount_ > 0 && sketchInEntries > 0) {
            this.performIntersect(sketchIn);
            return;
        }
        assert (false) : "Should not happen";
        return;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.wseg_;
    }

    @Override
    public CompactThetaSketch getResult(boolean dstOrdered, MemorySegment dstSeg) {
        long[] hashTable;
        if (this.curCount_ < 0) {
            throw new SketchesStateException("Calling getResult() with no intervening intersections would represent the infinite set, which is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCache = new long[]{};
            boolean srcCompact = true;
            boolean srcOrdered = false;
            return CompactOperations.componentsToCompact(this.thetaLong_, this.curCount_, this.seedHash_, this.empty_, srcCompact, srcOrdered, dstOrdered, dstSeg, compactCache);
        }
        if (this.wseg_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            MemorySegment.copy(this.wseg_, ValueLayout.JAVA_LONG_UNALIGNED, 24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] compactCache = ThetaIntersectionImpl.compactCachePart(hashTable, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        boolean srcCompact = true;
        boolean srcOrdered = dstOrdered;
        return CompactOperations.componentsToCompact(this.thetaLong_, this.curCount_, this.seedHash_, this.empty_, srcCompact, srcOrdered, dstOrdered, dstSeg, compactCache);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.wseg_ != null && this.wseg_.scope().isAlive();
    }

    @Override
    public boolean hasResult() {
        return this.hasMemorySegment() ? this.wseg_.get(ValueLayout.JAVA_INT_UNALIGNED, 8L) >= 0 : this.curCount_ >= 0;
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.wseg_.isNative();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this.hasMemorySegment() && MemorySegmentStatus.isSameResource(this.wseg_, that);
    }

    @Override
    public void reset() {
        this.hardReset();
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[24 + dataBytes];
        if (this.wseg_ != null) {
            MemorySegment.copy(this.wseg_, ValueLayout.JAVA_BYTE, 0L, byteArrOut, 0, 24 + dataBytes);
        } else {
            MemorySegment segOut = MemorySegment.ofArray(byteArrOut);
            segOut.set(ValueLayout.JAVA_BYTE, 0L, (byte)3);
            segOut.set(ValueLayout.JAVA_BYTE, 1L, (byte)3);
            segOut.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.INTERSECTION.getID());
            segOut.set(ValueLayout.JAVA_BYTE, 3L, (byte)0);
            segOut.set(ValueLayout.JAVA_BYTE, 4L, (byte)this.lgArrLongs_);
            if (this.empty_) {
                Util.setBits(segOut, 5L, (byte)4);
            } else {
                Util.clearBits(segOut, 5L, (byte)4);
            }
            segOut.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, this.seedHash_);
            segOut.set(ValueLayout.JAVA_INT_UNALIGNED, 8L, this.curCount_);
            segOut.set(ValueLayout.JAVA_FLOAT_UNALIGNED, 12L, 1.0f);
            segOut.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, this.thetaLong_);
            if (this.curCount_ > 0) {
                MemorySegment.copy(this.hashTable_, 0, segOut, ValueLayout.JAVA_LONG_UNALIGNED, 24L, 1 << this.lgArrLongs_);
            }
        }
        return byteArrOut;
    }

    @Override
    int getRetainedEntries() {
        return this.curCount_;
    }

    @Override
    boolean isEmpty() {
        return this.empty_;
    }

    @Override
    long[] getCache() {
        if (this.wseg_ == null) {
            return this.hashTable_ != null ? this.hashTable_ : new long[]{};
        }
        int arrLongs = 1 << this.lgArrLongs_;
        long[] outArr = new long[arrLongs];
        MemorySegment.copy(this.wseg_, ValueLayout.JAVA_LONG_UNALIGNED, 24L, outArr, 0, arrLongs);
        return outArr;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    private void performIntersect(ThetaSketch sketchIn) {
        long[] hashTable;
        assert (this.curCount_ > 0 && !this.empty_);
        if (this.wseg_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            MemorySegment.copy(this.wseg_, ValueLayout.JAVA_LONG_UNALIGNED, 24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        boolean isOrdered = sketchIn.isOrdered();
        HashIterator it = sketchIn.iterator();
        while (it.next()) {
            long hashIn = it.get();
            if (hashIn < this.thetaLong_) {
                int foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn);
                if (foundIdx == -1) continue;
                matchSet[matchSetCount++] = hashIn;
                continue;
            }
            if (!isOrdered) continue;
            break;
        }
        this.curCount_ = matchSetCount;
        this.lgArrLongs_ = HashOperations.minLgHashTableSize(matchSetCount, 0.9375);
        if (this.wseg_ != null) {
            PreambleUtil.insertCurCount(this.wseg_, matchSetCount);
            PreambleUtil.insertLgArrLongs(this.wseg_, this.lgArrLongs_);
            this.wseg_.asSlice(24L, 8 << this.lgArrLongs_).fill((byte)0);
        } else {
            Arrays.fill(this.hashTable_, 0, 1 << this.lgArrLongs_, 0L);
        }
        if (this.curCount_ > 0) {
            this.moveDataToTgt(matchSet, matchSetCount);
        } else if (this.thetaLong_ == Long.MAX_VALUE) {
            this.empty_ = true;
        }
    }

    private void moveDataToTgt(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        if (this.wseg_ != null) {
            int preBytes = 24;
            int lgArrLongs = this.lgArrLongs_;
            long thetaLong = this.thetaLong_;
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(thetaLong, hashIn)) continue;
                HashOperations.hashInsertOnlyMemorySegment(this.wseg_, lgArrLongs, hashIn, 24);
                ++tmpCnt;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
                HashOperations.hashInsertOnly(this.hashTable_, this.lgArrLongs_, hashIn);
                ++tmpCnt;
            }
        }
        assert (tmpCnt == count) : "ThetaIntersection Count Check: got: " + tmpCnt + ", expected: " + count;
    }

    private void moveDataToTgt(ThetaSketch sketch) {
        int count = sketch.getRetainedEntries();
        int tmpCnt = 0;
        if (this.wseg_ != null) {
            int preBytes = 24;
            int lgArrLongs = this.lgArrLongs_;
            long thetaLong = this.thetaLong_;
            HashIterator it = sketch.iterator();
            while (it.next()) {
                long hash = it.get();
                if (HashOperations.continueCondition(thetaLong, hash)) continue;
                HashOperations.hashInsertOnlyMemorySegment(this.wseg_, lgArrLongs, hash, 24);
                ++tmpCnt;
            }
        } else {
            HashIterator it = sketch.iterator();
            while (it.next()) {
                long hash = it.get();
                if (HashOperations.continueCondition(this.thetaLong_, hash)) continue;
                HashOperations.hashInsertOnly(this.hashTable_, this.lgArrLongs_, hash);
                ++tmpCnt;
            }
        }
        assert (tmpCnt == count) : "ThetaIntersection Count Check: got: " + tmpCnt + ", expected: " + count;
    }

    private void hardReset() {
        this.resetCommon();
        if (this.wseg_ != null) {
            PreambleUtil.insertCurCount(this.wseg_, -1);
            PreambleUtil.clearEmpty(this.wseg_);
        }
        this.curCount_ = -1;
        this.empty_ = false;
    }

    private void resetToEmpty() {
        this.resetCommon();
        if (this.wseg_ != null) {
            PreambleUtil.insertCurCount(this.wseg_, 0);
            PreambleUtil.setEmpty(this.wseg_);
        }
        this.curCount_ = 0;
        this.empty_ = true;
    }

    private void resetCommon() {
        if (this.wseg_ != null) {
            if (this.readOnly_) {
                throw new SketchesReadOnlyException();
            }
            this.wseg_.asSlice(24L, 256L).fill((byte)0);
            PreambleUtil.insertLgArrLongs(this.wseg_, 5);
            PreambleUtil.insertThetaLong(this.wseg_, Long.MAX_VALUE);
        }
        this.lgArrLongs_ = 5;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashTable_ = null;
    }

    static final long[] compactCachePart(long[] srcCache, int lgArrLongs, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = 1 << lgArrLongs;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    private static void checkMinSizeMemorySegment(MemorySegment seg) {
        int minBytes = 280;
        long cap = seg.byteSize();
        if (cap < 280L) {
            throw new SketchesArgumentException("MemorySegment must be at least 280 bytes. Actual capacity: " + cap);
        }
    }

    private static int getMaxLgArrLongs(MemorySegment dstSeg) {
        int preBytes = 24;
        long cap = dstSeg.byteSize();
        return Integer.numberOfTrailingZeros(Util.floorPowerOf2((int)(cap - 24L)) >>> 3);
    }

    private static void segChecks(MemorySegment srcSeg) {
        int preLongs = ThetaSketch.getPreambleLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int famID = PreambleUtil.extractFamilyID(srcSeg);
        boolean empty = (PreambleUtil.extractFlags(srcSeg) & 4) > 0;
        int curCount = PreambleUtil.extractCurCount(srcSeg);
        if (preLongs != 3) {
            throw new SketchesArgumentException("MemorySegment PreambleLongs must equal 3: " + preLongs);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Serialization Version must equal 3");
        }
        Family.INTERSECTION.checkFamilyID(famID);
        if (empty && curCount != 0) {
            throw new SketchesArgumentException("srcSeg empty state inconsistent with curCount: " + empty + "," + curCount);
        }
    }
}

